/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.jsf.metadataprocessors.AbstractMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.IType;
import org.eclipse.jst.jsf.metadataprocessors.ITypeDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.internal.IMetaDataEnabledFeatureExtension;
import org.eclipse.jst.jsf.metadataprocessors.internal.MetaDataEnabledFeatureAdapterFactory;
import org.eclipse.jst.jsf.metadataprocessors.internal.MetaDataEnabledFeatureRegistry;

public abstract class AbstractRootTypeDescriptor
extends AbstractMetaDataEnabledFeature
implements ITypeDescriptor {
    private IType type;

    public List getFeatureAdapters(Class processingFeature) {
        Assert.isTrue((boolean)processingFeature.isInterface());
        ArrayList<IMetaDataEnabledFeature> ret = new ArrayList<IMetaDataEnabledFeature>(3);
        if (processingFeature.isInstance(this)) {
            ret.add(this);
        }
        ret.addAll(this.findMetaDataEnabledFeaturesForThisType(processingFeature));
        return ret;
    }

    protected final List<IMetaDataEnabledFeature> findMetaDataEnabledFeaturesForThisType(Class processingFeature) {
        HashMap<String, IMetaDataEnabledFeature> mapOfFeatures = new HashMap<String, IMetaDataEnabledFeature>();
        List<IMetaDataEnabledFeatureExtension> extensions = MetaDataEnabledFeatureRegistry.getInstance().getFeatures(this.getTypeExtension().getTypeID());
        if (!extensions.isEmpty()) {
            int i = 0;
            while (i < extensions.size()) {
                IMetaDataEnabledFeatureExtension aFeature = extensions.get(i);
                IMetaDataEnabledFeature feature = MetaDataEnabledFeatureAdapterFactory.getInstance().getFeatureAdapter(aFeature, processingFeature);
                if (feature != null && processingFeature.isInstance(feature) && !mapOfFeatures.containsKey(aFeature.getClassName())) {
                    mapOfFeatures.put(aFeature.getClassName(), feature);
                }
                ++i;
            }
        }
        ArrayList<IMetaDataEnabledFeature> ret = new ArrayList<IMetaDataEnabledFeature>(mapOfFeatures.size());
        for (IMetaDataEnabledFeature feature : mapOfFeatures.values()) {
            ret.add(feature);
        }
        return ret;
    }

    @Override
    public IType getTypeExtension() {
        return this.type;
    }

    @Override
    public void setTypeExtension(IType type) {
        this.type = type;
    }
}

