/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.util;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupportDelegate;

public final class FacetModuleCoreSupport {
    static final boolean _dump_NCDFE = false;
    private static final String WEB_INF = "WEB-INF";
    private static final IPath WEB_INF_PATH = new Path("WEB-INF");
    static final String META_INF_RESOURCES = "META-INF/resources/";
    static final IPath META_INF_RESOURCES_PATH = new Path("META-INF/resources/");
    static final float DEFAULT_SERVLET_VERSION = 5.0f;

    public static IPath computeWebContentRootPath(IPath path) {
        IPath root = null;
        try {
            root = FacetModuleCoreSupportDelegate.getWebContentRootPath(ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (root == null) {
            root = FacetModuleCoreSupport.getLocalRoot(path);
        }
        return root;
    }

    public static float getDynamicWebFragmentVersion(IProject project) {
        float version = -1.0f;
        try {
            version = FacetModuleCoreSupportDelegate.getDynamicWebFragmentVersion(project);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return version;
    }

    public static float getDynamicWebProjectVersion(IProject project) {
        float version = -1.0f;
        try {
            version = FacetModuleCoreSupportDelegate.getDynamicWebProjectVersion(project);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return version;
    }

    public static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        IPath path = null;
        try {
            path = FacetModuleCoreSupportDelegate.getWebContentRootPath(project);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return path;
    }

    public static IPath[] getAcceptableRootPaths(IProject project) {
        if (project == null) {
            return null;
        }
        IPath[] paths = null;
        try {
            paths = FacetModuleCoreSupportDelegate.getAcceptableRootPaths(project);
        }
        catch (NoClassDefFoundError e) {
            return new IPath[]{project.getFullPath()};
        }
        return paths;
    }

    public static IPath getRuntimePath(IPath path) {
        IPath result = null;
        try {
            result = FacetModuleCoreSupportDelegate.getRuntimePath(path);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (result == null) {
            IPath root = FacetModuleCoreSupport.getLocalRoot(path);
            result = path.removeFirstSegments(root.segmentCount()).makeAbsolute();
        }
        return result;
    }

    public static boolean isDynamicWebProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            return FacetModuleCoreSupportDelegate.isDynamicWebProject(project);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return true;
        }
    }

    public static boolean isWebFragmentProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            return FacetModuleCoreSupportDelegate.isWebFragmentProject(project);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return true;
        }
    }

    public static IPath resolve(IPath basePath, String reference) {
        IPath resolvedPath = null;
        try {
            resolvedPath = FacetModuleCoreSupportDelegate.resolve(basePath, reference);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (resolvedPath == null) {
            IPath rootPath = FacetModuleCoreSupport.getLocalRoot(basePath);
            resolvedPath = reference.startsWith(Path.ROOT.toString()) ? rootPath.append(reference) : basePath.removeLastSegments(1).append(reference);
        }
        return resolvedPath;
    }

    private static IPath getLocalRoot(IPath basePath) {
        IFile[] files;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)basePath);
        if (file == null && basePath.segmentCount() > 1) {
            file = workspaceRoot.getFolder(basePath);
        }
        if (file != null && !file.exists() && basePath.segmentCount() > 1) {
            file = workspaceRoot.getFile(basePath);
        }
        if (file == null && basePath.segmentCount() == 1) {
            file = workspaceRoot.getProject(basePath.segment(0));
        }
        if (file == null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(basePath)).length > 0) {
            file = files[0];
        }
        while (file != null) {
            IContainer folder = null;
            folder = (file.getType() & 2) != 0 ? (IContainer)file : file.getParent();
            if (folder != null && (folder.getType() & 8) == 0) {
                IFolder webinf = folder.getFolder(WEB_INF_PATH);
                IFolder metaResources = folder.getFolder(META_INF_RESOURCES_PATH);
                if (webinf != null && webinf.exists() || metaResources != null && metaResources.exists()) {
                    return folder.getFullPath();
                }
            }
            file = file.getParent();
        }
        return basePath.uptoSegment(1);
    }

    public static IProject[] getReferenced(IProject project) {
        if (project == null) {
            return null;
        }
        IProject[] projects = null;
        try {
            projects = FacetModuleCoreSupportDelegate.getReferenced(project);
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        return projects;
    }

    public static IPath getRootContainerForPath(IProject project, IPath path) {
        if (project == null) {
            return null;
        }
        IPath root = null;
        try {
            root = FacetModuleCoreSupportDelegate.getRootContainerForPath(project, path);
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        return root;
    }

    public static IPath getDefaultRootContainer(IProject project) {
        if (project == null) {
            return null;
        }
        IPath root = null;
        try {
            root = FacetModuleCoreSupportDelegate.getDefaultRoot(project);
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        return root;
    }
}

