/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.search;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class SearchNode
implements DOMRange {
    private final int start;
    private final int end;
    private final DOMNode node;
    private final String prefix;
    private final Direction direction;
    private ValidationStatus validationStatus;

    public SearchNode(int start, int end, DOMNode node, String prefix, Direction direction) {
        this.start = start;
        this.end = end;
        this.node = node;
        this.prefix = prefix;
        this.direction = direction;
    }

    public String getValue(String forcedPrefix) {
        StringBuilder value = new StringBuilder();
        if (forcedPrefix != null) {
            value.append(forcedPrefix);
        }
        String text = this.getOwnerDocument().getText();
        for (int i = this.getStart(); i < this.getEnd(); ++i) {
            value.append(text.charAt(i));
        }
        return value.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean matchesValue(SearchNode searchNode) {
        int length;
        int fromStart = this.getStart();
        int fromEnd = this.getEnd();
        String fromText = this.getOwnerDocument().getText();
        if (this.direction == Direction.FROM) {
            int adjust = SearchNode.adjustWithPrefix(this);
            if (adjust == -1) {
                return false;
            }
            fromStart += adjust;
        }
        int toStart = searchNode.getStart();
        int toEnd = searchNode.getEnd();
        String toText = searchNode.getOwnerDocument().getText();
        if (this.direction == Direction.TO) {
            int adjust = SearchNode.adjustWithPrefix(searchNode);
            if (adjust == -1) {
                return false;
            }
            toStart += adjust;
        }
        if ((length = fromEnd - fromStart) != toEnd - toStart) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (fromText.charAt(i + fromStart) == toText.charAt(i + toStart)) continue;
            return false;
        }
        return true;
    }

    private static int adjustWithPrefix(SearchNode node) {
        String prefix = node.getPrefix();
        if (prefix == null) {
            return 0;
        }
        if (!node.isValidPrefix()) {
            return -1;
        }
        return prefix.length();
    }

    public DOMNode getNode() {
        return this.node;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return this.node.getOwnerDocument();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Range createRange() {
        return this.createRange(false);
    }

    public Range createRange(boolean checkPrefix) {
        Range range = XMLPositionUtility.createRange(this);
        if (checkPrefix && this.isNeedToAjdustWithPrefix()) {
            Position start = range.getStart();
            start.setCharacter(start.getCharacter() + this.getPrefix().length());
        }
        return range;
    }

    public boolean isNeedToAjdustWithPrefix() {
        return this.getDirection() == Direction.FROM && this.getPrefix() != null;
    }

    public boolean isValid() {
        return this.getValidationStatus() == ValidationStatus.OK;
    }

    public ValidationStatus getValidationStatus() {
        if (this.validationStatus == null) {
            this.validationStatus = this.validate();
        }
        return this.validationStatus;
    }

    private ValidationStatus validate() {
        if (!this.isValidPrefix()) {
            return ValidationStatus.INVALID_PREFIX;
        }
        if (this.start == this.end - (this.prefix != null ? this.prefix.length() : 0)) {
            return ValidationStatus.EMPTY_VALUE;
        }
        return ValidationStatus.OK;
    }

    private boolean isValidPrefix() {
        if (this.direction == Direction.TO) {
            return true;
        }
        String prefix = this.getPrefix();
        if (prefix == null) {
            return true;
        }
        if (prefix.length() > this.end - this.start) {
            return false;
        }
        String text = this.node.getOwnerDocument().getText();
        for (int i = 0; i < prefix.length(); ++i) {
            if (text.charAt(this.start + i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String text = this.node.getOwnerDocument().getText();
        result.append(text.substring(this.start, this.end));
        result.append(this.direction == Direction.FROM ? " -->" : " <--");
        return result.toString();
    }

    public static enum ValidationStatus {
        INVALID_PREFIX,
        EMPTY_VALUE,
        OK;

    }

    public static enum Direction {
        FROM,
        TO;

    }
}

