/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.index.lucene.LucenePlugin;
import org.eclipse.dltk.internal.core.index.lucene.IndexRecovery;
import org.eclipse.dltk.internal.core.index.lucene.IndexType;
import org.eclipse.dltk.internal.core.index.lucene.Logger;
import org.eclipse.dltk.internal.core.index.lucene.Utils;

class IndexContainer {
    private static final String TIMESTAMPS_DIR = "timestamps";
    private final String fIndexRoot;
    private final String fContainerId;
    private IndexWriter fTimestampsWriter;
    private SearcherManager fTimestampsSearcher;
    private Map<IndexType, Map<Integer, IndexWriter>> fIndexWriters;
    private Map<IndexType, Map<Integer, SearcherManager>> fIndexSearchers;

    public IndexContainer(String indexRoot, String containerId) {
        this.fIndexRoot = indexRoot;
        this.fContainerId = containerId;
        this.initialize();
    }

    private void initialize() {
        this.fIndexWriters = new HashMap<IndexType, Map<Integer, IndexWriter>>();
        this.fIndexWriters.put(IndexType.DECLARATIONS, new HashMap());
        this.fIndexWriters.put(IndexType.REFERENCES, new HashMap());
        this.fIndexSearchers = new HashMap<IndexType, Map<Integer, SearcherManager>>();
        this.fIndexSearchers.put(IndexType.DECLARATIONS, new HashMap());
        this.fIndexSearchers.put(IndexType.REFERENCES, new HashMap());
    }

    private IndexWriter createWriter(Path path) throws IOException {
        NoFsyncDirectory indexDir = new NoFsyncDirectory(FSDirectory.open((Path)path, (LockFactory)new SingleInstanceLockFactory()));
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)new SimpleAnalyzer());
        config.setUseCompoundFile(false);
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        config.setCommitOnClose(false);
        IndexWriter writer = new IndexWriter((Directory)indexDir, config);
        return writer;
    }

    private IndexWriter getWriter(Path path) {
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.createWriter(path);
        }
        catch (IOException e) {
            IndexRecovery.tryRecover(this, path, e);
            try {
                indexWriter = this.createWriter(path);
            }
            catch (IOException ex) {
                Logger.logException(ex);
            }
        }
        return indexWriter;
    }

    public final String getId() {
        return this.fContainerId;
    }

    public IndexWriter getTimestampsWriter() {
        if (this.fTimestampsWriter == null) {
            Path writerPath = Paths.get(this.fIndexRoot, this.fContainerId, TIMESTAMPS_DIR);
            this.fTimestampsWriter = this.getWriter(writerPath);
        }
        return this.fTimestampsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearcherManager getTimestampsSearcher() {
        try {
            boolean refresh = true;
            if (this.fTimestampsSearcher == null) {
                IndexContainer indexContainer = this;
                synchronized (indexContainer) {
                    if (this.fTimestampsSearcher == null) {
                        this.fTimestampsSearcher = new SearcherManager(this.getTimestampsWriter(), true, false, new SearcherFactory());
                        refresh = false;
                    }
                }
            }
            if (refresh) {
                this.fTimestampsSearcher.maybeRefresh();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        return this.fTimestampsSearcher;
    }

    private Path getPath(IndexType dataType, int elementType) {
        return Paths.get(this.fIndexRoot, this.fContainerId, dataType.getDirectory(), String.valueOf(elementType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter getIndexWriter(IndexType dataType, int elementType) {
        IndexWriter writer = this.fIndexWriters.get((Object)dataType).get(elementType);
        if (writer == null) {
            Map<IndexType, Map<Integer, IndexWriter>> map = this.fIndexWriters;
            synchronized (map) {
                writer = this.fIndexWriters.get((Object)dataType).get(elementType);
                if (writer == null) {
                    Path writerPath = this.getPath(dataType, elementType);
                    writer = this.getWriter(writerPath);
                    this.fIndexWriters.get((Object)dataType).put(elementType, writer);
                }
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearcherManager getIndexSearcher(IndexType dataType, int elementType) {
        SearcherManager searcher;
        block7: {
            searcher = this.fIndexSearchers.get((Object)dataType).get(elementType);
            try {
                if (searcher != null) break block7;
                Map<IndexType, Map<Integer, SearcherManager>> map = this.fIndexSearchers;
                synchronized (map) {
                    searcher = this.fIndexSearchers.get((Object)dataType).get(elementType);
                    if (searcher == null) {
                        searcher = new SearcherManager(this.getIndexWriter(dataType, elementType), new SearcherFactory());
                        this.fIndexSearchers.get((Object)dataType).put(elementType, searcher);
                    }
                }
            }
            catch (IndexNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return searcher;
    }

    public void delete(String sourceModule) {
        Term term = new Term("path", sourceModule);
        try {
            this.getTimestampsWriter().deleteDocuments(new Term[]{term});
            for (Map<Integer, IndexWriter> dataWriters : this.fIndexWriters.values()) {
                for (IndexWriter writer : dataWriters.values()) {
                    writer.deleteDocuments(new Term[]{term});
                }
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public void delete(boolean wait) {
        new IndexCleaner().clean(!wait);
    }

    public synchronized void close() {
        try {
            if (this.fTimestampsSearcher != null) {
                this.fTimestampsSearcher.close();
            }
            if (this.fTimestampsWriter != null) {
                this.fTimestampsWriter.close();
            }
            for (Map<Integer, SearcherManager> map : this.fIndexSearchers.values()) {
                for (SearcherManager searcherManager : map.values()) {
                    if (searcherManager == null) continue;
                    searcherManager.close();
                }
            }
            for (Map<Integer, SearcherManager> map : this.fIndexWriters.values()) {
                for (IndexWriter indexWriter : map.values()) {
                    if (indexWriter == null || !indexWriter.isOpen()) continue;
                    indexWriter.close();
                }
            }
        }
        catch (IOException iOException) {
            Logger.logException(iOException);
        }
    }

    boolean hasChanges() {
        for (Map<Integer, IndexWriter> dataWriters : this.fIndexWriters.values()) {
            for (IndexWriter writer : dataWriters.values()) {
                if (writer == null || !writer.hasUncommittedChanges()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() {
        LinkedList<IndexWriter> writers = new LinkedList<IndexWriter>();
        Map<IndexType, Map<Integer, IndexWriter>> map = this.fIndexWriters;
        synchronized (map) {
            for (Map<Integer, IndexWriter> dataWriters : this.fIndexWriters.values()) {
                for (IndexWriter writer : dataWriters.values()) {
                    if (writer == null) continue;
                    writers.add(writer);
                }
            }
        }
        try {
            for (IndexWriter writer : writers) {
                writer.commit();
            }
            if (this.fTimestampsWriter != null) {
                this.fTimestampsWriter.commit();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexContainer refresh() {
        LinkedList<SearcherManager> managers = new LinkedList<SearcherManager>();
        Map<IndexType, Map<Integer, SearcherManager>> map = this.fIndexSearchers;
        synchronized (map) {
            for (Map<Integer, SearcherManager> searcher : this.fIndexSearchers.values()) {
                for (SearcherManager man : searcher.values()) {
                    if (man == null) continue;
                    managers.add(man);
                }
            }
        }
        for (SearcherManager man : managers) {
            try {
                man.maybeRefreshBlocking();
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return this;
    }

    private final class IndexCleaner
    extends Job {
        public IndexCleaner() {
            super("");
            this.setUser(false);
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == LucenePlugin.LUCENE_JOB_FAMILY;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.doClean();
            return Status.OK_STATUS;
        }

        void clean(boolean fork) {
            if (fork) {
                this.schedule();
            } else {
                this.doClean();
            }
        }

        private void doClean() {
            IndexContainer.this.close();
            Path containerPath = Paths.get(IndexContainer.this.fIndexRoot, IndexContainer.this.getId());
            try {
                Utils.delete(containerPath);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
    }

    private static class NoFsyncDirectory
    extends FilterDirectory {
        protected NoFsyncDirectory(FSDirectory in) {
            super((Directory)in);
        }

        public void sync(Collection<String> names) throws IOException {
        }

        public void syncMetaData() throws IOException {
        }
    }
}

