/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.wikitext.validation.ValidationRule;

public class ValidationRules {
    private ValidationRules parent;
    private final List<ValidationRule> rules = new ArrayList<ValidationRule>();

    public void addValidationRule(ValidationRule rule) {
        this.rules.add(rule);
    }

    public List<ValidationRule> getRules() {
        if (this.parent != null) {
            List<ValidationRule> parentRules = this.parent.getRules();
            if (this.rules.isEmpty()) {
                return parentRules;
            }
            if (parentRules.isEmpty()) {
                return Collections.unmodifiableList(this.rules);
            }
            ArrayList<ValidationRule> combined = new ArrayList<ValidationRule>(this.rules.size() + parentRules.size());
            combined.addAll(parentRules);
            combined.addAll(this.rules);
            return Collections.unmodifiableList(combined);
        }
        return Collections.unmodifiableList(this.rules);
    }

    public ValidationRules getParent() {
        return this.parent;
    }

    public void setParent(ValidationRules parent) {
        this.parent = parent;
    }
}

