/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetPropertyTester
extends PropertyTester {
    private static final String P_HAS_C_PROJECTS = "hasCProjects";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (P_HAS_C_PROJECTS.equals(property)) {
            return this.hasCProjects(this.getWorkingSet(receiver));
        }
        return false;
    }

    private IWorkingSet getWorkingSet(Object object) {
        IWorkingSet result = null;
        if (object instanceof IWorkingSet) {
            result = (IWorkingSet)object;
        } else if (object instanceof IAdaptable) {
            result = (IWorkingSet)((IAdaptable)object).getAdapter(IWorkingSet.class);
        }
        return result;
    }

    private boolean hasCProjects(IWorkingSet workingSet) {
        boolean result = false;
        if (workingSet != null) {
            IAdaptable[] members;
            IAdaptable[] iAdaptableArray = members = workingSet.getElements();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable next = iAdaptableArray[n2];
                IProject project = (IProject)next.getAdapter(IProject.class);
                if (project != null && CoreModel.hasCNature((IProject)project)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }
}

