/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocument;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLPropertyDeclaration;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.contentassist.HTMLMinimalContentModelGenerator;
import org.eclipse.wst.html.ui.internal.contentassist.XHTMLMinimalContentModelGenerator;
import org.eclipse.wst.html.ui.internal.editor.HTMLEditorPluginImageHelper;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMElementDeclarationImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractXMLModelQueryCompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationPresenter;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationProvider;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class HTMLTagsCompletionProposalComputer
extends AbstractXMLModelQueryCompletionProposalComputer {
    protected boolean isXHTML = false;
    private IContextInformationValidator fContextInformationValidator = null;

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)context.getViewer(), (int)context.getInvocationOffset());
        IDOMNode node = (IDOMNode)treeNode;
        boolean isXHTMLNode = HTMLTagsCompletionProposalComputer.isXHTMLNode((Node)node);
        if (this.isXHTML != isXHTMLNode) {
            this.isXHTML = isXHTMLNode;
        }
        return super.computeCompletionProposals(context, monitor);
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        AttributeContextInformationProvider attributeInfoProvider = new AttributeContextInformationProvider((IStructuredDocument)context.getDocument(), (AttributeContextInformationPresenter)this.getContextInformationValidator());
        return Arrays.asList(attributeInfoProvider.getAttributeInformation(context.getInvocationOffset()));
    }

    protected XMLContentModelGenerator getContentGenerator() {
        if (this.isXHTML) {
            return XHTMLMinimalContentModelGenerator.getInstance();
        }
        return HTMLMinimalContentModelGenerator.getInstance();
    }

    protected boolean validModelQueryNode(CMNode node) {
        boolean isValid = false;
        Object cmdoc = node.getProperty("CMDocument");
        if (cmdoc instanceof CMNode) {
            String name = ((CMNode)cmdoc).getNodeName();
            isValid = name != null && name.endsWith(".dtd") && name.indexOf("html") != -1;
        } else if (node.supports("isHTML")) {
            Boolean isHTML = (Boolean)node.getProperty("isHTML");
            isValid = isHTML == null || isHTML != false;
        } else if (node instanceof HTMLPropertyDeclaration) {
            HTMLPropertyDeclaration propDec = (HTMLPropertyDeclaration)node;
            isValid = !propDec.isJSP();
        } else if (node instanceof CMAttributeDeclaration || node instanceof CMElementDeclarationImpl) {
            isValid = true;
        } else if (node instanceof CMElementDeclaration) {
            Boolean isXHTML = (Boolean)node.getProperty("isXHTML");
            boolean bl = isValid = isXHTML != null && isXHTML != false;
        }
        if (isValid && node.supports("isObsolete")) {
            Boolean isObsolete = (Boolean)node.getProperty("isObsolete");
            isValid = isObsolete == null || isObsolete == false;
        }
        return isValid;
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.addHTMLTagProposal(contentAssistRequest, context);
    }

    protected void addStartDocumentProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        boolean xmlpiIsFirstElement;
        Node aNode = contentAssistRequest.getNode();
        Document owningDocument = aNode.getOwnerDocument();
        Node first = owningDocument.getFirstChild();
        boolean bl = xmlpiIsFirstElement = first != null && first.getNodeType() == 7;
        if (xmlpiIsFirstElement && owningDocument.getDoctype() == null && this.isCursorAfterXMLPI(contentAssistRequest)) {
            this.addDocTypeProposal(contentAssistRequest, true);
        } else {
            this.addDocTypeProposal(contentAssistRequest, false);
        }
    }

    private void addDocTypeProposal(ContentAssistRequest contentAssistRequest, boolean isXHTML) {
        String rootname = "unspecified";
        if (contentAssistRequest.getNode().getOwnerDocument().getDocumentElement() != null) {
            rootname = contentAssistRequest.getNode().getOwnerDocument().getDocumentElement().getNodeName();
        }
        HTMLDocumentTypeEntry entry = isXHTML ? HTMLDocumentTypeRegistry.getInstance().getXHTMLDefaultEntry() : HTMLDocumentTypeRegistry.getInstance().getDefaultEntry();
        String proposedText = "<!DOCTYPE " + rootname + " PUBLIC \"" + entry.getPublicId() + "\" \"" + entry.getSystemId() + "\">";
        CustomCompletionProposal proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), 10, XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/doctype.gif"), String.valueOf(entry.getDisplayName()) + " " + HTMLUIMessages.Expandable_label_document_type, null, null, 600);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
    }

    private void addHTMLTagProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        IStructuredModel model = null;
        try {
            CMElementDeclaration htmlDecl;
            CMDocument correspondingCMDocument;
            IDOMDocument doc;
            ModelQuery mq;
            if (context.getDocument() instanceof IStructuredDocument) {
                model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)context.getDocument());
            }
            if (model != null && (mq = ModelQueryUtil.getModelQuery((Document)(doc = ((IDOMModel)model).getDocument()))) != null && (correspondingCMDocument = mq.getCorrespondingCMDocument((Node)doc)) != null && (htmlDecl = (CMElementDeclaration)correspondingCMDocument.getElements().getNamedItem("HTML".toLowerCase())) != null) {
                StringBuffer proposedTextBuffer = new StringBuffer();
                this.getContentGenerator().generateTag((Node)doc, htmlDecl, proposedTextBuffer);
                String proposedText = proposedTextBuffer.toString();
                String requiredName = this.getContentGenerator().getRequiredName((Node)doc, (CMNode)htmlDecl);
                IStructuredDocumentRegion region = contentAssistRequest.getDocumentRegion();
                if (region != null && region.getFirstRegion() != null && region.getFirstRegion().getType().equals("XML_TAG_OPEN")) {
                    proposedText = proposedText.substring(1);
                }
                if (!HTMLTagsCompletionProposalComputer.beginsWith((String)proposedText, (String)contentAssistRequest.getMatchString())) {
                    return;
                }
                int cursorAdjustment = HTMLTagsCompletionProposalComputer.getCursorPositionForProposedText((String)proposedText);
                CustomCompletionProposal proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), cursorAdjustment, HTMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif"), requiredName, null, null, 1200);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private static boolean isXHTMLNode(Node node) {
        DocumentType docType;
        if (node == null) {
            return false;
        }
        Document doc = null;
        doc = node.getNodeType() != 9 ? node.getOwnerDocument() : (Document)node;
        if (doc instanceof IDOMDocument) {
            return ((IDOMDocument)doc).isXMLType();
        }
        if (doc instanceof INodeNotifier) {
            ModelQueryAdapter adapter = (ModelQueryAdapter)((INodeNotifier)doc).getAdapterFor(ModelQueryAdapter.class);
            CMDocument cmdoc = null;
            if (adapter != null && adapter.getModelQuery() != null) {
                cmdoc = adapter.getModelQuery().getCorrespondingCMDocument((Node)doc);
            }
            if (cmdoc != null) {
                if (cmdoc instanceof HTMLCMDocument) {
                    return false;
                }
                if (cmdoc.supports("isXHTML")) {
                    return Boolean.TRUE.equals(cmdoc.getProperty("isXHTML"));
                }
            }
        }
        return (docType = doc.getDoctype()) != null && docType.getPublicId() != null && docType.getPublicId().indexOf("-//W3C//DTD XHTML ") == 0;
    }

    private IContextInformationValidator getContextInformationValidator() {
        if (this.fContextInformationValidator == null) {
            this.fContextInformationValidator = new AttributeContextInformationPresenter();
        }
        return this.fContextInformationValidator;
    }
}

