/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.IncludeGroupStyleBlock;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IncludeCategoriesBlock
extends OptionsConfigurationBlock {
    private final List<IncludeGroupStyle> styles;
    private final Map<IncludeGroupStyle.IncludeKind, Category> categories = new HashMap<IncludeGroupStyle.IncludeKind, Category>();
    private TreeListDialogField<Category> categoryTree;
    private PixelConverter pixelConverter;
    private StackLayout editorAreaStack;
    private Category selectedCategory;

    public IncludeCategoriesBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, List<IncludeGroupStyle> styles) {
        super(context, project, new OptionsConfigurationBlock.Key[0], container);
        this.styles = styles;
        this.createCategories();
    }

    private void createCategories() {
        this.createCategory(IncludeGroupStyle.IncludeKind.RELATED);
        this.createCategory(IncludeGroupStyle.IncludeKind.PARTNER);
        this.createCategory(IncludeGroupStyle.IncludeKind.IN_SAME_FOLDER);
        this.createCategory(IncludeGroupStyle.IncludeKind.IN_SUBFOLDER);
        this.createCategory(IncludeGroupStyle.IncludeKind.SYSTEM);
        this.createCategory(IncludeGroupStyle.IncludeKind.SYSTEM_WITH_EXTENSION);
        this.createCategory(IncludeGroupStyle.IncludeKind.SYSTEM_WITHOUT_EXTENSION);
        this.createCategory(IncludeGroupStyle.IncludeKind.OTHER);
        this.createCategory(IncludeGroupStyle.IncludeKind.IN_SAME_PROJECT);
        this.createCategory(IncludeGroupStyle.IncludeKind.IN_OTHER_PROJECT);
        this.createCategory(IncludeGroupStyle.IncludeKind.EXTERNAL);
    }

    private Category createCategory(IncludeGroupStyle.IncludeKind includeKind) {
        Category parentCategory = this.categories.get((Object)includeKind.parent);
        Category category = new Category(includeKind, parentCategory);
        this.categories.put(category.getIncludeKind(), category);
        return category;
    }

    public void postSetSelection(Object element) {
        this.categoryTree.postSetSelection((ISelection)new StructuredSelection(element));
    }

    @Override
    protected Control createContents(Composite parent) {
        this.pixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        IncludeStyleAdapter adapter = new IncludeStyleAdapter();
        this.categoryTree = new TreeListDialogField<Category>(adapter, null, (ILabelProvider)new IncludeStyleLabelProvider());
        this.categoryTree.setDialogFieldListener(adapter);
        this.categoryTree.setLabelText(PreferencesMessages.IncludeCategoriesBlock_header_categories);
        this.categoryTree.setViewerComparator(adapter);
        for (Category category : this.categories.values()) {
            if (category.parent != null) continue;
            this.categoryTree.addElement(category);
        }
        Label label = this.categoryTree.getLabelControl(composite);
        label.setLayoutData((Object)new GridData(4, 1, false, false));
        Control tree = this.categoryTree.getTreeControl(composite);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.pixelConverter.convertWidthInCharsToPixels(50);
        gd.heightHint = this.pixelConverter.convertHeightInCharsToPixels(2);
        tree.setLayoutData((Object)gd);
        this.createCategoryEditors(composite);
        this.categoryTree.setTreeExpansionLevel(2);
        this.categoryTree.selectFirstElement();
        this.updateControls();
        return composite;
    }

    private void createCategoryEditors(Composite parent) {
        Composite editorArea = new Composite(parent, 0);
        editorArea.setLayoutData((Object)new GridData(4, 1024, true, false));
        editorArea.setFont(parent.getFont());
        this.editorAreaStack = new StackLayout();
        editorArea.setLayout((Layout)this.editorAreaStack);
        HashMap<IncludeGroupStyle.IncludeKind, IncludeGroupStyle> stylesByKind = new HashMap<IncludeGroupStyle.IncludeKind, IncludeGroupStyle>();
        for (IncludeGroupStyle style : this.styles) {
            if (style.getIncludeKind() == IncludeGroupStyle.IncludeKind.MATCHING_PATTERN) continue;
            stylesByKind.put(style.getIncludeKind(), style);
        }
        for (Category category : this.categories.values()) {
            IncludeGroupStyleBlock block = new IncludeGroupStyleBlock(this.fContext, this.fProject, this.fContainer, category.getDescription());
            IncludeGroupStyle style = (IncludeGroupStyle)stylesByKind.get((Object)category.getIncludeKind());
            block.setStyle(style);
            Control composite = block.createContents(editorArea);
            category.setEditor(block, composite);
        }
    }

    @Override
    protected void updateControls() {
        super.updateControls();
        this.categoryTree.refresh();
        this.updateConfigurationBlock(this.categoryTree.getSelectedElements());
        for (Category category : this.categories.values()) {
            category.getEditor().updateControls();
        }
    }

    private void updateConfigurationBlock(List<Object> selection) {
        if (selection.size() == 0) {
            return;
        }
        this.selectedCategory = (Category)selection.get(0);
        this.editorAreaStack.topControl = this.selectedCategory.getEditorArea();
        this.editorAreaStack.topControl.getParent().layout();
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        this.fContext.statusChanged(new StatusInfo());
    }

    private static final class Category {
        public final Category parent;
        public final int index;
        private final List<Category> children;
        private final IncludeGroupStyle.IncludeKind includeKind;
        private Control editorArea;
        private IncludeGroupStyleBlock editor;

        Category(IncludeGroupStyle.IncludeKind includeKind, Category parent) {
            this.includeKind = includeKind;
            this.parent = parent;
            this.children = new ArrayList<Category>();
            this.index = parent != null ? parent.addChild(this) : 0;
        }

        private int addChild(Category category) {
            this.children.add(category);
            return this.children.size() - 1;
        }

        Category[] getChildren() {
            return this.children.toArray(new Category[this.children.size()]);
        }

        boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public String toString() {
            return this.includeKind.name;
        }

        IncludeGroupStyle.IncludeKind getIncludeKind() {
            return this.includeKind;
        }

        IncludeGroupStyleBlock getEditor() {
            return this.editor;
        }

        Control getEditorArea() {
            return this.editorArea;
        }

        void setEditor(IncludeGroupStyleBlock editor, Control editorArea) {
            this.editor = editor;
            this.editorArea = editorArea;
        }

        String getName() {
            return this.includeKind.name;
        }

        String getDescription() {
            return this.includeKind.description;
        }
    }

    private class IncludeStyleAdapter
    extends ViewerComparator
    implements ITreeListAdapter<Category>,
    IDialogFieldListener {
        private IncludeStyleAdapter() {
        }

        @Override
        public void selectionChanged(TreeListDialogField<Category> field) {
            IncludeCategoriesBlock.this.updateConfigurationBlock(field.getSelectedElements());
        }

        @Override
        public void customButtonPressed(TreeListDialogField<Category> field, int index) {
        }

        @Override
        public void doubleClicked(TreeListDialogField<Category> field) {
        }

        public Category[] getChildren(TreeListDialogField<Category> field, Object element) {
            return ((Category)element).getChildren();
        }

        public Category getParent(TreeListDialogField<Category> field, Object element) {
            return ((Category)element).parent;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<Category> field, Object element) {
            return ((Category)element).hasChildren();
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }

        @Override
        public void keyPressed(TreeListDialogField<Category> field, KeyEvent event) {
        }

        public int category(Object element) {
            return ((Category)element).index;
        }
    }

    private static class IncludeStyleLabelProvider
    extends LabelProvider {
        private IncludeStyleLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((Category)element).getName();
        }
    }
}

