/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyCommentDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyCommentDetailsUrlAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyCommenterNameAction;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class CommentActionGroup
extends ActionGroup {
    private CopyCommentDetailsAction copyDetailsAction;
    private CopyCommenterNameAction copyCommenterNameAction;
    private CopyCommentDetailsUrlAction copyCommentDetailsURL;
    private boolean initialized;

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.copyDetailsAction = new CopyCommentDetailsAction();
        this.copyCommenterNameAction = new CopyCommenterNameAction();
        this.copyCommentDetailsURL = new CopyCommentDetailsUrlAction();
    }

    public void fillContextMenu(IMenuManager manager) {
        this.updateActions();
        manager.add((IAction)this.copyDetailsAction);
        manager.add((IAction)this.copyCommenterNameAction);
        manager.add((IAction)this.copyCommentDetailsURL);
    }

    private void updateActions() {
        this.initialize();
        IStructuredSelection selection = this.getStructuredSelection();
        this.copyDetailsAction.selectionChanged(selection);
        this.copyCommenterNameAction.selectionChanged(selection);
        this.copyCommentDetailsURL.selectionChanged(selection);
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof ITaskComment) {
            this.copyCommentDetailsURL.setEnabled(((ITaskComment)firstElement).getUrl() != null);
        }
    }

    public IStructuredSelection getStructuredSelection() {
        ISelection selection;
        ActionContext context = this.getContext();
        if (context != null && (selection = context.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }
}

