/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.internal.ui.actions.SessionAction;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class RegisterPackagesAction
extends SessionAction {
    private List<EPackage> ePackages;
    private int errors;

    public RegisterPackagesAction(IWorkbenchPage page, String text, String toolTipText, ImageDescriptor image, CDOSession session) {
        super(page, text, toolTipText, image, session);
    }

    protected void preRun() throws Exception {
        this.ePackages = this.getEPackages(this.getPage(), this.getSession());
        if (this.ePackages == null) {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        this.errors = 0;
        CDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        for (EPackage ePackage : this.ePackages) {
            EcoreUtil.freeze((EPackage)ePackage);
            Resource resource = ePackage.eResource();
            URI uri = resource == null ? null : resource.getURI();
            try {
                packageRegistry.putEPackage(ePackage);
            }
            catch (RuntimeException ex) {
                ++this.errors;
                if (uri == null) {
                    OM.LOG.error((Throwable)ex);
                    continue;
                }
                OM.LOG.error(MessageFormat.format(Messages.getString("RegisterPackagesAction.0"), uri), (Throwable)ex);
            }
        }
        this.postRegistration(this.ePackages);
        if (this.errors != 0) {
            final String label = this.errors == 1 ? MessageFormat.format(Messages.getString("RegisterPackagesAction.1"), this.errors) : MessageFormat.format(Messages.getString("RegisterPackagesAction.2"), this.errors);
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = RegisterPackagesAction.this.getShell();
                    if (!shell.isDisposed()) {
                        MessageDialog.openError((Shell)shell, (String)RegisterPackagesAction.this.getText(), (String)label);
                    }
                }
            });
        }
    }

    protected void postRegistration(List<EPackage> ePackages) {
    }

    protected abstract List<EPackage> getEPackages(IWorkbenchPage var1, CDOSession var2);
}

