/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import java.util.function.Predicate;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.AbstractMergeContainedAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeNonConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MergeContainedNonConflictingAction
extends AbstractMergeContainedAction {
    public MergeContainedNonConflictingAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable, IStructuredSelection selection, Predicate<TreeNode> isFiltered) {
        super(compareConfiguration, mergerRegistry, mode, navigatable);
        this.isFiltered = isFiltered;
        this.setEnabled(this.updateSelection(selection));
    }

    @Override
    protected void initToolTipAndImage(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setText(EMFCompareIDEUIMessages.getString("merged.contained.to.right.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.contained.to.right.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/etoolb16/merge_contained_non_conflicting_diffs_to_right.png"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setText(EMFCompareIDEUIMessages.getString("merged.contained.to.left.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.contained.to.left.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/etoolb16/merge_contained_non_conflicting_diffs_to_left.png"));
                break;
            }
            case ACCEPT: {
                this.setText(EMFCompareIDEUIMessages.getString("accept.contained.changes.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.contained.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/etoolb16/accept_contained_non_conflicting_diffs.png"));
                break;
            }
            case REJECT: {
                this.setText(EMFCompareIDEUIMessages.getString("reject.contained.changes.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.contained.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/etoolb16/reject_contained_non_conflicting_diffs.png"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    protected IMergeRunnable createMergeRunnable(MergeMode mode, boolean isLeftEditable, boolean isRightEditable, IDiffRelationshipComputer relationshipComputer) {
        return new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mode, relationshipComputer);
    }

    @Override
    protected Predicate<Diff> getDiffPredicate() {
        return EMFComparePredicates.guavaToJava((com.google.common.base.Predicate)EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}));
    }
}

