/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.plugin.NewPluginProjectWizard;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class FeatureSpecSection
extends PDESection {
    private FormEntry fIdText;
    private FormEntry fTitleText;
    private FormEntry fVersionText;
    private FormEntry fProviderText;
    private FormEntry fPluginText;
    private FormEntry fUpdateSiteNameText;
    private FormEntry fUpdateSiteUrlText;
    private FormEntry fPatchedIdText;
    private FormEntry fPatchedVersionText;
    private boolean fPatch = false;
    private Button fIncludesSourcesCheckbox;

    public FeatureSpecSection(FeatureFormPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEUIMessages.FeatureEditor_SpecSection_title);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.fTitleText.commit();
        this.fProviderText.commit();
        this.fIdText.commit();
        this.fPluginText.commit();
        this.fVersionText.commit();
        if (this.fPatchedIdText != null) {
            this.fPatchedIdText.commit();
            this.fPatchedVersionText.commit();
        }
        this.fUpdateSiteUrlText.commit();
        this.fUpdateSiteNameText.commit();
        super.commit(onSave);
    }

    private void commitSiteUrl(String value) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureURL urlElement = feature.getURL();
        if (urlElement == null) {
            urlElement = model.getFactory().createURL();
            try {
                feature.setURL(urlElement);
            }
            catch (CoreException e) {
                return;
            }
        }
        try {
            IFeatureURLElement updateElement = urlElement.getUpdate();
            if (value.length() > 0) {
                URL siteUrl = new URL(value);
                if (updateElement == null) {
                    updateElement = model.getFactory().createURLElement(urlElement, 1);
                    updateElement.setURL(siteUrl);
                    urlElement.setUpdate(updateElement);
                } else {
                    updateElement.setURL(siteUrl);
                }
            } else if (updateElement != null) {
                if (updateElement.getLabel() != null && updateElement.getLabel().length() > 0) {
                    updateElement.setURL(null);
                } else {
                    urlElement.setUpdate(null);
                }
            }
        }
        catch (MalformedURLException | CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void commitSiteName(String value) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureURL urlElement = feature.getURL();
        if (urlElement == null) {
            urlElement = model.getFactory().createURL();
            try {
                feature.setURL(urlElement);
            }
            catch (CoreException e) {
                return;
            }
        }
        try {
            IFeatureURLElement updateElement = urlElement.getUpdate();
            if (value.length() > 0) {
                if (updateElement == null) {
                    updateElement = model.getFactory().createURLElement(urlElement, 1);
                    updateElement.setLabel(value);
                    urlElement.setUpdate(updateElement);
                } else {
                    updateElement.setLabel(value);
                }
            } else if (updateElement != null) {
                if (updateElement.getURL() != null) {
                    updateElement.setLabel(null);
                } else {
                    urlElement.setUpdate(null);
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IFeatureImport getPatchedFeature() {
        IFeatureImport[] imports;
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureImport[] iFeatureImportArray = imports = feature.getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport featureImport = iFeatureImportArray[n2];
            if (featureImport.isPatch()) {
                return featureImport;
            }
            ++n2;
        }
        FeatureImport fimport = (FeatureImport)model.getFactory().createImport();
        try {
            fimport.setType(1);
            fimport.setPatch(true);
            feature.addImports(new IFeatureImport[]{fimport});
        }
        catch (CoreException ce) {
            PDEPlugin.logException(ce);
        }
        return null;
    }

    private boolean isPatch() {
        return this.fPatch;
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData twd = new TableWrapData();
        twd.grabHorizontal = true;
        section.setLayoutData((Object)twd);
        this.fPatch = ((FeatureEditor)this.getPage().getEditor()).isPatchEditor();
        final IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        final IFeature feature = model.getFeature();
        if (this.isPatch()) {
            this.getSection().setDescription(PDEUIMessages.FeatureEditor_SpecSection_desc_patch);
        } else {
            this.getSection().setDescription(PDEUIMessages.FeatureEditor_SpecSection_desc);
        }
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        container.setLayoutData((Object)new GridData(768));
        this.fIdText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_id, null, false);
        this.fIdText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    feature.setId(text.getValue().trim());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fVersionText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_version, null, false);
        this.fVersionText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                if (!FeatureSpecSection.this.verifySetVersion(feature, text.getValue())) {
                    FeatureSpecSection.this.warnBadVersionFormat(text.getValue());
                    text.setValue(feature.getVersion());
                }
            }
        });
        this.fTitleText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_name, null, false);
        this.fTitleText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    feature.setLabel(text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                FeatureSpecSection.this.getPage().getManagedForm().getForm().setText(model.getResourceString(feature.getLabel()));
                ((FeatureEditor)FeatureSpecSection.this.getPage().getEditor()).updateTitle();
            }
        });
        this.fProviderText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_provider, null, false);
        this.fProviderText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    String value = text.getValue();
                    feature.setProviderName(value.length() > 0 ? value : null);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fPluginText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_plugin, PDEUIMessages.GeneralInfoSection_browse, this.isEditable());
        this.fPluginText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    String value = text.getValue();
                    feature.setPlugin(value.length() > 0 ? value : null);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
                String plugin = FeatureSpecSection.this.fPluginText.getValue();
                if (PluginRegistry.findModel((String)plugin) == null) {
                    this.createFeaturePlugin();
                }
                ManifestEditor.openPluginEditor(FeatureSpecSection.this.fPluginText.getValue());
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                FeatureSpecSection.this.handleOpenDialog();
            }

            private void createFeaturePlugin() {
                NewPluginProjectWizard wizard = new NewPluginProjectWizard();
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                if (dialog.open() == 0) {
                    String plugin = wizard.getPluginId();
                    try {
                        feature.setPlugin(plugin);
                        FeatureSpecSection.this.fPluginText.setValue(plugin, false);
                    }
                    catch (CoreException ce) {
                        PDEPlugin.logException(ce);
                    }
                }
            }
        });
        if (this.isPatch()) {
            this.fPatchedIdText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_patchedId, null, false);
            this.fPatchedIdText.setFormEntryListener(new FormEntryAdapter(this){

                @Override
                public void textValueChanged(FormEntry text) {
                    try {
                        IFeatureImport patchImport = FeatureSpecSection.this.getPatchedFeature();
                        if (patchImport != null) {
                            patchImport.setId(text.getValue());
                        }
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            });
            this.fPatchedVersionText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_patchedVersion, null, false);
            this.fPatchedVersionText.setFormEntryListener(new FormEntryAdapter(this){

                @Override
                public void textValueChanged(FormEntry text) {
                    IFeatureImport patchImport = FeatureSpecSection.this.getPatchedFeature();
                    if (patchImport != null && !FeatureSpecSection.this.verifySetVersion(patchImport, text.getValue())) {
                        FeatureSpecSection.this.warnBadVersionFormat(text.getValue());
                        text.setValue(patchImport.getVersion());
                    }
                }
            });
        }
        this.fUpdateSiteUrlText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_updateUrl, null, false);
        this.fUpdateSiteUrlText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                String url;
                String string = url = text.getValue() != null ? text.getValue() : "";
                if (url.length() > 0 && !FeatureSpecSection.this.verifySiteUrl(feature, url)) {
                    FeatureSpecSection.this.warnBadUrl(url);
                    FeatureSpecSection.this.setUpdateSiteUrlText();
                } else {
                    FeatureSpecSection.this.commitSiteUrl(url);
                }
            }
        });
        this.fUpdateSiteNameText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_updateUrlLabel, null, false);
        this.fUpdateSiteNameText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                String name = text.getValue() != null ? text.getValue() : "";
                FeatureSpecSection.this.commitSiteName(name);
            }
        });
        this.fIncludesSourcesCheckbox = toolkit.createButton(container, PDEUIMessages.FeatureSpecSection_addSources0, 32);
        this.fIncludesSourcesCheckbox.setLayoutData((Object)new GridData(768));
        this.fIncludesSourcesCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean isSelected = this.fIncludesSourcesCheckbox.getSelection();
            feature.setIncludingSources(isSelected);
        }));
        GridData gd = (GridData)this.fIdText.getText().getLayoutData();
        gd.widthHint = 150;
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private boolean verifySetVersion(IFeature feature, String value) {
        try {
            if (VersionUtil.validateVersion((String)value).isOK()) {
                feature.setVersion(value);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean verifySetVersion(IFeatureImport featureImport, String value) {
        try {
            if (VersionUtil.validateVersion((String)value).isOK()) {
                featureImport.setVersion(value);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean verifySiteUrl(IFeature feature, String value) {
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    private void warnBadVersionFormat(String text) {
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.FeatureEditor_SpecSection_badVersionTitle, (String)PDEUIMessages.FeatureEditor_SpecSection_badVersionMessage);
    }

    private void warnBadUrl(String text) {
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.FeatureEditor_SpecSection_badUrlTitle, (String)PDEUIMessages.FeatureEditor_SpecSection_badUrlMessage);
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        if (!model.isEditable()) {
            this.fIdText.getText().setEditable(false);
            this.fTitleText.getText().setEditable(false);
            this.fVersionText.getText().setEditable(false);
            this.fProviderText.getText().setEditable(false);
            this.fPluginText.getText().setEditable(false);
            if (this.isPatch()) {
                this.fPatchedIdText.getText().setEditable(false);
                this.fPatchedVersionText.getText().setEditable(false);
            }
            this.fUpdateSiteUrlText.getText().setEditable(false);
            this.fUpdateSiteNameText.getText().setEditable(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        Object[] objs;
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (e.getChangeType() == 3 && (objs = e.getChangedObjects()).length > 0 && objs[0] instanceof IFeature) {
            this.markStale();
        }
        if (e.getChangeType() == 3 && (objs = e.getChangedObjects()).length > 0 && objs[0] instanceof IFeatureURL) {
            this.markStale();
        }
        if ((objs = e.getChangedObjects()).length > 0 && objs[0] instanceof IFeatureURLElement) {
            this.markStale();
        }
        if (this.isPatch() && objs.length > 0 && objs[0] instanceof IFeatureImport) {
            this.markStale();
        }
    }

    public void setFocus() {
        if (this.fIdText != null) {
            this.fIdText.getText().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.setIfDefined(this.fIdText, feature.getId());
        this.setIfDefined(this.fTitleText, feature.getLabel());
        this.getPage().getManagedForm().getForm().setText(model.getResourceString(feature.getLabel()));
        this.setIfDefined(this.fVersionText, feature.getVersion());
        this.fIncludesSourcesCheckbox.setSelection(feature.isIncludingSources());
        this.setIfDefined(this.fProviderText, feature.getProviderName());
        this.setIfDefined(this.fPluginText, feature.getPlugin());
        if (this.isPatch()) {
            IFeatureImport featureImport = this.getPatchedFeature();
            if (featureImport != null) {
                this.fPatchedIdText.setValue(featureImport.getId() != null ? featureImport.getId() : "", true);
                this.fPatchedVersionText.setValue(featureImport.getVersion() != null ? featureImport.getVersion() : "", true);
            } else {
                this.fPatchedIdText.setValue("", true);
                this.fPatchedVersionText.setValue("", true);
            }
        }
        this.setUpdateSiteUrlText();
        this.setUpdateSiteNameText();
        super.refresh();
    }

    private void setUpdateSiteUrlText() {
        IFeatureURLElement urlElement;
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        String updateSiteUrl = "";
        IFeatureURL featureUrl = feature.getURL();
        if (featureUrl != null && (urlElement = featureUrl.getUpdate()) != null) {
            updateSiteUrl = urlElement.getURL() != null ? urlElement.getURL().toExternalForm() : null;
        }
        this.fUpdateSiteUrlText.setValue(updateSiteUrl != null ? updateSiteUrl : "", true);
    }

    private void setUpdateSiteNameText() {
        IFeatureURLElement urlElement;
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        String updateSiteLabel = "";
        IFeatureURL featureUrl = feature.getURL();
        if (featureUrl != null && (urlElement = featureUrl.getUpdate()) != null) {
            updateSiteLabel = urlElement.getLabel();
        }
        this.fUpdateSiteNameText.setValue(updateSiteLabel != null ? updateSiteLabel : "", true);
    }

    @Override
    public void cancelEdit() {
        this.fIdText.cancelEdit();
        this.fTitleText.cancelEdit();
        this.fVersionText.cancelEdit();
        this.fProviderText.cancelEdit();
        this.fPluginText.cancelEdit();
        if (this.isPatch()) {
            this.fPatchedIdText.cancelEdit();
            this.fPatchedVersionText.cancelEdit();
        }
        this.fUpdateSiteNameText.cancelEdit();
        this.fUpdateSiteUrlText.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        TransferData[] transferDataArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData type = transferDataArray[n2];
            Transfer[] transferArray = transfers;
            int n3 = transfers.length;
            int n4 = 0;
            while (n4 < n3) {
                Transfer transfer = transferArray[n4];
                if (transfer.isSupportedType(type)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    protected void handleOpenDialog() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.getSection().getShell(), false, false);
        dialog.create();
        if (dialog.open() == 0) {
            IPluginModel model = (IPluginModel)dialog.getFirstResult();
            IPlugin plugin = model.getPlugin();
            this.fPluginText.setValue(plugin.getId());
        }
    }
}

