/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.dltk.internal.ui.preferences.ScriptSourcePreviewerUpdater;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.preferences.EditTemplateDialog;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.templates.ICodeTemplateAccess;
import org.eclipse.dltk.ui.text.templates.ICodeTemplateCategory;
import org.eclipse.dltk.ui.text.templates.ProjectTemplateStore;
import org.eclipse.dltk.ui.text.templates.TemplateVariableProcessor;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CodeTemplateBlock
extends OptionsConfigurationBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_IMPORT = 3;
    private static final int IDX_EXPORT = 4;
    private static final int IDX_EXPORTALL = 5;
    private TreeListDialogField fCodeTemplateTree;
    protected ProjectTemplateStore fTemplateStore;
    private PixelConverter fPixelConverter;
    private SourceViewer fPatternViewer;
    private final IDLTKUILanguageToolkit toolkit;
    private final ICodeTemplateAccess codeTemplateAccess;
    private TemplateVariableProcessor fTemplateProcessor;

    private static PreferenceKey[] getAllKeys() {
        return new PreferenceKey[0];
    }

    public CodeTemplateBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, IDLTKUILanguageToolkit toolkit, ICodeTemplateAccess codeTemplateAccess) {
        super(context, project, CodeTemplateBlock.getAllKeys(), container);
        this.toolkit = toolkit;
        this.codeTemplateAccess = codeTemplateAccess;
        this.fTemplateStore = new ProjectTemplateStore(codeTemplateAccess, project);
        try {
            this.fTemplateStore.load();
        }
        catch (IOException e) {
            DLTKUIPlugin.log(e);
        }
        this.fTemplateProcessor = new TemplateVariableProcessor();
        CodeTemplateAdapter adapter = new CodeTemplateAdapter();
        String[] buttonLabels = new String[]{PreferencesMessages.CodeTemplateBlock_templates_new_button, PreferencesMessages.CodeTemplateBlock_templates_edit_button, PreferencesMessages.CodeTemplateBlock_templates_remove_button, PreferencesMessages.CodeTemplateBlock_templates_import_button, PreferencesMessages.CodeTemplateBlock_templates_export_button, PreferencesMessages.CodeTemplateBlock_templates_exportall_button};
        this.fCodeTemplateTree = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CodeTemplateLabelProvider());
        this.fCodeTemplateTree.setDialogFieldListener(adapter);
        this.fCodeTemplateTree.setLabelText(PreferencesMessages.CodeTemplateBlock_templates_label);
        this.fCodeTemplateTree.setViewerComparator(adapter);
        this.fCodeTemplateTree.enableButton(4, false);
        this.fCodeTemplateTree.enableButton(0, false);
        this.fCodeTemplateTree.enableButton(1, false);
        this.fCodeTemplateTree.enableButton(2, false);
        this.fCodeTemplateTree.addElements(Arrays.asList(codeTemplateAccess.getCategories()));
        this.fCodeTemplateTree.selectFirstElement();
        this.updateControls();
    }

    public void postSetSelection(Object element) {
        this.fCodeTemplateTree.postSetSelection((ISelection)new StructuredSelection(element));
    }

    @Override
    public boolean hasProjectSpecificOptions(IProject project) {
        if (super.hasProjectSpecificOptions(project)) {
            return true;
        }
        if (project != null) {
            return this.fTemplateStore.hasProjectSpecificTempates(project);
        }
        return false;
    }

    @Override
    public void useProjectSpecificSettings(boolean enable) {
        this.fCodeTemplateTree.setEnabled(enable);
        super.useProjectSpecificSettings(enable);
    }

    @Override
    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fCodeTemplateTree.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fCodeTemplateTree.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fCodeTemplateTree.getTreeControl(null));
        this.fPatternViewer = this.createViewer(composite, 2);
        return composite;
    }

    protected void updateControls() {
    }

    private SourceViewer createViewer(Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setText(PreferencesMessages.CodeTemplateBlock_preview);
        GridData data = new GridData();
        data.horizontalSpan = nColumns;
        label.setLayoutData((Object)data);
        Document document = new Document();
        ScriptTextTools tools = this.toolkit.getTextTools();
        tools.setupDocumentPartitioner((IDocument)document);
        IPreferenceStore store = this.toolkit.getCombinedPreferenceStore();
        ScriptSourceViewer viewer = new ScriptSourceViewer(parent, null, null, false, 2816, store);
        ScriptSourceViewerConfiguration configuration = tools.createSourceViewerConfiguraton(store, null, this.fTemplateProcessor);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        Cursor arrowCursor = viewer.getTextWidget().getDisplay().getSystemCursor(0);
        viewer.getTextWidget().setCursor(arrowCursor);
        viewer.getTextWidget().setCaret(null);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)configuration.getFontPropertyPreferenceKey());
        viewer.getTextWidget().setFont(font);
        new ScriptSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        data = new GridData(1296);
        data.horizontalSpan = nColumns;
        data.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected TemplatePersistenceData[] getTemplatesOfCategory(ICodeTemplateCategory category) {
        ArrayList<TemplatePersistenceData> res = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] templates = this.fTemplateStore.getTemplateData();
        int i = 0;
        while (i < templates.length) {
            TemplatePersistenceData curr = templates[i];
            res.add(curr);
            ++i;
        }
        return res.toArray(new TemplatePersistenceData[res.size()]);
    }

    private TemplatePersistenceData[] getTemplatesOfContextType(TemplateContextType contextType) {
        return this.getTemplatesOfContextType(contextType.getId());
    }

    protected TemplatePersistenceData[] getTemplatesOfContextType(String contextTypeId) {
        ArrayList<TemplatePersistenceData> res = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] templates = this.fTemplateStore.getTemplateData();
        int i = 0;
        while (i < templates.length) {
            TemplatePersistenceData curr = templates[i];
            if (contextTypeId.equals(curr.getTemplate().getContextTypeId())) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new TemplatePersistenceData[res.size()]);
    }

    protected TemplateContextType[] getTemplateContextTypes(ICodeTemplateCategory category) {
        ArrayList<TemplateContextType> result = new ArrayList<TemplateContextType>();
        TemplateContextType[] contextTypes = category.getTemplateContextTypes();
        int i = 0;
        while (i < contextTypes.length) {
            TemplateContextType contextType = contextTypes[i];
            if (this.getTemplatesOfContextType(contextType).length > 0) {
                result.add(contextType);
            }
            ++i;
        }
        return result.toArray(new TemplateContextType[result.size()]);
    }

    protected boolean canAdd(List selected) {
        if (selected.size() == 1) {
            TemplatePersistenceData data;
            ICodeTemplateCategory category;
            Object element = selected.get(0);
            if (element instanceof TemplateContextType || element instanceof ICodeTemplateCategory && ((ICodeTemplateCategory)element).isGroup()) {
                return true;
            }
            if (element instanceof TemplatePersistenceData && (category = this.codeTemplateAccess.getCategoryOfContextType((data = (TemplatePersistenceData)element).getTemplate().getContextTypeId())) != null && category.isGroup()) {
                return true;
            }
        }
        return false;
    }

    protected static boolean canEdit(List selected) {
        return selected.size() == 1 && selected.get(0) instanceof TemplatePersistenceData;
    }

    protected static boolean canRemove(List selected) {
        if (selected.size() == 1 && selected.get(0) instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selected.get(0);
            return data.isUserAdded();
        }
        return false;
    }

    protected void updateSourceViewerInput(List selection) {
        if (this.fPatternViewer == null || this.fPatternViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (selection.size() == 1 && selection.get(0) instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.get(0);
            Template template = data.getTemplate();
            TemplateContextType type = this.codeTemplateAccess.getContextTypeRegistry().getContextType(template.getContextTypeId());
            this.fTemplateProcessor.setContextType(type);
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void doButtonPressed(int buttonIndex, List selected) {
        switch (buttonIndex) {
            case 1: {
                this.edit((TemplatePersistenceData)selected.get(0), false);
                break;
            }
            case 0: {
                String contextTypeId;
                Object element = selected.get(0);
                Template orig = null;
                if (element instanceof TemplatePersistenceData) {
                    orig = ((TemplatePersistenceData)element).getTemplate();
                    contextTypeId = orig.getContextTypeId();
                } else if (element instanceof TemplateContextType) {
                    TemplateContextType type = (TemplateContextType)selected.get(0);
                    contextTypeId = type.getId();
                } else if (element instanceof ICodeTemplateCategory) {
                    contextTypeId = ((ICodeTemplateCategory)element).getTemplateContextTypes()[0].getId();
                } else {
                    return;
                }
                Template newTemplate = orig != null ? new Template("", "", contextTypeId, orig.getPattern(), false) : new Template("", "", contextTypeId, "", false);
                TemplatePersistenceData newData = new TemplatePersistenceData(newTemplate, true);
                this.edit(newData, true);
                break;
            }
            case 2: {
                this.remove((TemplatePersistenceData)selected.get(0));
                break;
            }
            case 4: {
                this.export(selected);
                break;
            }
            case 5: {
                this.exportAll();
                break;
            }
            case 3: {
                this.import_();
            }
        }
    }

    private void remove(TemplatePersistenceData data) {
        if (data.isUserAdded()) {
            this.fTemplateStore.delete(data);
            this.fCodeTemplateTree.refresh();
        }
    }

    private void edit(TemplatePersistenceData data, boolean isNew) {
        ContextTypeRegistry contextTypeRegistry;
        Template newTemplate = new Template(data.getTemplate());
        ICodeTemplateCategory category = this.codeTemplateAccess.getCategoryOfContextType(newTemplate.getContextTypeId());
        if (category == null) {
            return;
        }
        if (category.isGroup()) {
            contextTypeRegistry = new ContextTypeRegistry();
            TemplateContextType[] contextTypes = category.getTemplateContextTypes();
            int i = 0;
            while (i < contextTypes.length) {
                contextTypeRegistry.addContextType(contextTypes[i]);
                ++i;
            }
        } else {
            contextTypeRegistry = this.codeTemplateAccess.getContextTypeRegistry();
        }
        EditTemplateDialog dialog = new EditTemplateDialog(this.toolkit, this.getShell(), newTemplate, !isNew, data.isUserAdded(), category.isGroup(), contextTypeRegistry);
        if (dialog.open() == 0) {
            data.setTemplate(dialog.getTemplate());
            if (isNew) {
                this.fTemplateStore.addTemplateData(data);
            }
            if (isNew || category.isGroup()) {
                this.fCodeTemplateTree.refresh();
            } else {
                this.fCodeTemplateTree.refresh(data);
            }
            this.fCodeTemplateTree.selectElements((ISelection)new StructuredSelection((Object)data));
        }
    }

    private void import_() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(PreferencesMessages.CodeTemplateBlock_import_title);
        dialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_import_extension});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            TemplateReaderWriter reader = new TemplateReaderWriter();
            File file = new File(path);
            if (file.exists()) {
                Throwable throwable = null;
                Object var6_9 = null;
                try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
                    TemplatePersistenceData[] datas = reader.read((InputStream)input, null);
                    int i = 0;
                    while (i < datas.length) {
                        this.updateTemplate(datas[i]);
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.fCodeTemplateTree.refresh();
            this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
        }
        catch (FileNotFoundException e) {
            this.openReadErrorDialog(e);
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void updateTemplate(TemplatePersistenceData data) {
        String dataId = data.getId();
        TemplatePersistenceData[] datas = this.fTemplateStore.getTemplateData();
        if (dataId != null) {
            int i = 0;
            while (i < datas.length) {
                TemplatePersistenceData data2 = datas[i];
                String id = data2.getId();
                if (id != null && id.equals(dataId)) {
                    data2.setTemplate(data.getTemplate());
                    return;
                }
                ++i;
            }
        } else {
            String dataName = data.getTemplate().getName();
            int i = 0;
            while (i < datas.length) {
                TemplatePersistenceData data2 = datas[i];
                if (data2.getId() == null) {
                    String name = data2.getTemplate().getName();
                    String contextTypeId = data2.getTemplate().getContextTypeId();
                    if (name != null && name.equals(dataName) && contextTypeId.equals(data.getTemplate().getContextTypeId())) {
                        data2.setTemplate(data.getTemplate());
                        return;
                    }
                }
                ++i;
            }
            this.fTemplateStore.addTemplateData(data);
        }
    }

    private void exportAll() {
        this.export(this.fTemplateStore.getTemplateData());
    }

    private void export(List selected) {
        HashSet<TemplatePersistenceData> datas = new HashSet<TemplatePersistenceData>();
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof TemplatePersistenceData) {
                datas.add((TemplatePersistenceData)curr);
            } else if (curr instanceof TemplateContextType) {
                TemplatePersistenceData[] cat = this.getTemplatesOfContextType((TemplateContextType)curr);
                datas.addAll(Arrays.asList(cat));
            } else if (curr instanceof ICodeTemplateCategory) {
                ICodeTemplateCategory category = (ICodeTemplateCategory)curr;
                if (category.isGroup()) {
                    TemplateContextType[] types = this.getTemplateContextTypes(category);
                    int j = 0;
                    while (j < types.length) {
                        TemplateContextType contextType = types[j];
                        TemplatePersistenceData[] cat = this.getTemplatesOfContextType(contextType);
                        datas.addAll(Arrays.asList(cat));
                        ++j;
                    }
                } else {
                    TemplatePersistenceData[] cat = this.getTemplatesOfCategory(category);
                    datas.addAll(Arrays.asList(cat));
                }
            }
            ++i;
        }
        this.export(datas.toArray(new TemplatePersistenceData[datas.size()]));
    }

    private void export(TemplatePersistenceData[] templates) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(NLS.bind((String)PreferencesMessages.CodeTemplateBlock_export_title, (Object)String.valueOf(templates.length)));
        dialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_export_extension});
        dialog.setFileName(PreferencesMessages.CodeTemplateBlock_export_filename);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            String title = PreferencesMessages.CodeTemplateBlock_export_error_title;
            String message = NLS.bind((String)PreferencesMessages.CodeTemplateBlock_export_error_hidden, (Object)BasicElementLabels.getPathLabel(file));
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = PreferencesMessages.CodeTemplateBlock_export_error_title;
            String message = NLS.bind((String)PreferencesMessages.CodeTemplateBlock_export_error_canNotWrite, (Object)BasicElementLabels.getPathLabel(file));
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            try {
                Throwable title = null;
                Object var6_12 = null;
                try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
                    TemplateReaderWriter writer = new TemplateReaderWriter();
                    writer.save(templates, (OutputStream)output);
                    ((OutputStream)output).close();
                }
                catch (Throwable throwable) {
                    if (title == null) {
                        title = throwable;
                    } else if (title != throwable) {
                        title.addSuppressed(throwable);
                    }
                    throw title;
                }
            }
            catch (IOException e) {
                this.openWriteErrorDialog();
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferencesMessages.CodeTemplateBlock_export_exists_title, (String)NLS.bind((String)PreferencesMessages.CodeTemplateBlock_export_exists_message, (Object)BasicElementLabels.getPathLabel(file)));
    }

    @Override
    public void performDefaults() {
        this.fTemplateStore.restoreDefaults();
        this.fCodeTemplateTree.refresh();
        super.performDefaults();
    }

    public boolean performOk(boolean enabled) {
        boolean res = super.performOk();
        if (!res) {
            return false;
        }
        if (this.fProject != null) {
            TemplatePersistenceData[] templateData = this.fTemplateStore.getTemplateData();
            int i = 0;
            while (i < templateData.length) {
                this.fTemplateStore.setProjectSpecific(templateData[i].getId(), enabled);
                ++i;
            }
        }
        try {
            this.fTemplateStore.save();
        }
        catch (IOException e) {
            DLTKUIPlugin.log(e);
            this.openWriteErrorDialog();
        }
        return true;
    }

    public void performCancel() {
        try {
            this.fTemplateStore.revertChanges();
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void openReadErrorDialog(Exception e) {
        String title = PreferencesMessages.CodeTemplateBlock_error_read_title;
        String message = e.getLocalizedMessage();
        message = message != null ? NLS.bind((String)PreferencesMessages.CodeTemplateBlock_error_parse_message, (Object)message) : PreferencesMessages.CodeTemplateBlock_error_read_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openWriteErrorDialog() {
        String title = PreferencesMessages.CodeTemplateBlock_error_write_title;
        String message = PreferencesMessages.CodeTemplateBlock_error_write_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private class CodeTemplateAdapter
    extends ViewerComparator
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] NO_CHILDREN = new Object[0];

        private CodeTemplateAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField field, int index) {
            CodeTemplateBlock.this.doButtonPressed(index, field.getSelectedElements());
        }

        @Override
        public void selectionChanged(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            field.enableButton(0, CodeTemplateBlock.this.canAdd(selected));
            field.enableButton(1, CodeTemplateBlock.canEdit(selected));
            field.enableButton(2, CodeTemplateBlock.canRemove(selected));
            field.enableButton(4, !selected.isEmpty());
            CodeTemplateBlock.this.updateSourceViewerInput(selected);
        }

        @Override
        public void doubleClicked(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            if (CodeTemplateBlock.canEdit(selected)) {
                CodeTemplateBlock.this.doButtonPressed(1, selected);
            }
        }

        @Override
        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof ICodeTemplateCategory) {
                ICodeTemplateCategory category = (ICodeTemplateCategory)element;
                if (category.isGroup()) {
                    return CodeTemplateBlock.this.getTemplateContextTypes(category);
                }
                return CodeTemplateBlock.this.getTemplatesOfCategory(category);
            }
            if (element instanceof TemplateContextType) {
                return CodeTemplateBlock.this.getTemplatesOfContextType(((TemplateContextType)element).getId());
            }
            return this.NO_CHILDREN;
        }

        @Override
        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof TemplatePersistenceData) {
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                String contextTypeId = data.getTemplate().getContextTypeId();
                ICodeTemplateCategory category = CodeTemplateBlock.this.codeTemplateAccess.getCategoryOfContextType(contextTypeId);
                if (category == null) {
                    return null;
                }
                if (category.isGroup()) {
                    return CodeTemplateBlock.this.codeTemplateAccess.getContextTypeRegistry().getContextType(contextTypeId);
                }
                return category;
            }
            if (element instanceof TemplateContextType) {
                return CodeTemplateBlock.this.codeTemplateAccess.getCategoryOfContextType(((TemplateContextType)element).getId());
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element instanceof ICodeTemplateCategory || element instanceof TemplateContextType;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }

        @Override
        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }

        public int category(Object element) {
            if (element instanceof ICodeTemplateCategory) {
                return ((ICodeTemplateCategory)element).getPriority();
            }
            return 1000;
        }
    }

    private static class CodeTemplateLabelProvider
    extends LabelProvider {
        private CodeTemplateLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ICodeTemplateCategory) {
                return ((ICodeTemplateCategory)element).getName();
            }
            if (element instanceof TemplateContextType) {
                return ((TemplateContextType)element).getName();
            }
            if (element instanceof TemplatePersistenceData) {
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                return data.getTemplate().getDescription();
            }
            return element.toString();
        }
    }
}

