/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.commands;

import com.google.gson.JsonObject;
import java.util.Map;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.IXMLDocumentProvider;
import org.eclipse.lemminx.services.IXMLValidationService;
import org.eclipse.lemminx.services.extensions.commands.AbstractDOMDocumentCommandHandler;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.JSONUtility;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLValidationFileCommand
extends AbstractDOMDocumentCommandHandler {
    public static final String COMMAND_ID = "xml.validation.current.file";
    private final ContentModelManager contentModelManager;
    private final IXMLValidationService validationService;

    public XMLValidationFileCommand(ContentModelManager contentModelManager, IXMLDocumentProvider documentProvider, IXMLValidationService validationService) {
        super(documentProvider);
        this.contentModelManager = contentModelManager;
        this.validationService = validationService;
    }

    @Override
    protected Object executeCommand(DOMDocument document, ExecuteCommandParams params, SharedSettings sharedSettings, CancelChecker cancelChecker) throws Exception {
        JsonObject validationArgs = params.getArguments().size() > 1 ? (JsonObject)params.getArguments().get(1) : null;
        this.contentModelManager.evictCacheFor(document);
        Map map = JSONUtility.toModel(validationArgs, Map.class);
        this.validationService.validate(document, map);
        return null;
    }
}

