/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.local.AbstractMergeSet;
import org.eclipse.team.svn.core.operation.local.MergeSet1URL;
import org.eclipse.team.svn.core.operation.local.MergeSet2URL;
import org.eclipse.team.svn.core.operation.local.MergeSetReintegrate;

public class MergeScopeHelper {
    protected AbstractMergeSet info;

    public MergeScopeHelper() {
    }

    public MergeScopeHelper(AbstractMergeSet info) {
        this.info = info;
    }

    public String getName() {
        AbstractMergeSet info;
        if (this.info.to == null) {
            return "";
        }
        String url = null;
        if (this.info instanceof MergeSet1URL) {
            info = (MergeSet1URL)this.info;
            url = (info.from.length > 1 ? info.from[0].getRoot() : info.from[0]).getUrl();
        } else if (this.info instanceof MergeSet2URL) {
            info = (MergeSet2URL)this.info;
            url = (((MergeSet2URL)info).fromEnd.length > 1 ? ((MergeSet2URL)info).fromEnd[0].getRoot() : ((MergeSet2URL)info).fromEnd[0]).getUrl();
        } else {
            info = (MergeSetReintegrate)this.info;
            url = (((MergeSetReintegrate)info).from.length > 1 ? ((MergeSetReintegrate)info).from[0].getRoot() : ((MergeSetReintegrate)info).from[0]).getUrl();
        }
        String names = null;
        int i = 0;
        while (i < this.info.to.length) {
            String path = this.info.to[i].getFullPath().toString().substring(1);
            names = names == null ? path : String.valueOf(names) + ", " + path;
            ++i;
        }
        return SVNMessages.format(SVNMessages.MergeScope_Name, new String[]{url, names});
    }

    public IResource[] getRoots() {
        return this.info.to;
    }

    public void setMergeSet(AbstractMergeSet info) {
        this.info = info;
    }

    public AbstractMergeSet getMergeSet() {
        return this.info;
    }
}

