/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNMergeStatus;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.local.AbstractMergeSet;
import org.eclipse.team.svn.core.operation.local.IRemoteStatusOperation;
import org.eclipse.team.svn.core.operation.local.MergeSet1URL;
import org.eclipse.team.svn.core.operation.local.MergeSet2URL;
import org.eclipse.team.svn.core.operation.local.MergeSetReintegrate;
import org.eclipse.team.svn.core.operation.local.MergeStatusOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.resource.IChangeStateProvider;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSubscriber;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.IRemoteStatusCache;
import org.eclipse.team.svn.core.synchronize.MergeScopeHelper;
import org.eclipse.team.svn.core.synchronize.MergeSyncInfo;
import org.eclipse.team.svn.core.synchronize.RemoteStatusCache;
import org.eclipse.team.svn.core.synchronize.UpdateSyncInfo;
import org.eclipse.team.svn.core.synchronize.UpdateSyncInfoForMerge;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSubscriber
extends AbstractSVNSubscriber {
    private static MergeSubscriber instance = null;
    protected MergeScopeHelper mergeScopeHelper;
    protected MergeStatusOperation mergeStatusOp;
    protected IRemoteStatusCache baseStatusCache = new RemoteStatusCache();

    public static synchronized MergeSubscriber instance() {
        if (instance == null) {
            instance = new MergeSubscriber();
        }
        return instance;
    }

    public MergeScopeHelper getMergeScopeHelper() {
        return this.mergeScopeHelper;
    }

    public void setMergeScopeHelper(MergeScopeHelper scope) {
        this.mergeScopeHelper = scope;
    }

    @Override
    protected SyncInfo getSVNSyncInfo(ILocalResource localStatus, IResourceChange remoteStatus) throws TeamException {
        SVNMergeStatus mergeStatus;
        IResourceChange baseStatus = SVNRemoteStorage.instance().resourceChangeFromBytes(this.baseStatusCache.getBytes(localStatus.getResource()));
        AbstractSVNSyncInfo syncInfo = remoteStatus == null && baseStatus == null ? new MergeSyncInfo(localStatus, null, null, this.getResourceComparator()) : ((mergeStatus = this.getStatusFor(localStatus.getResource())) != null ? (mergeStatus.skipped ? new MergeSyncInfo(localStatus, baseStatus, remoteStatus, this.getResourceComparator()) : new UpdateSyncInfoForMerge(localStatus, baseStatus, remoteStatus, this.getResourceComparator())) : new UpdateSyncInfo(localStatus, null, this.getResourceComparator()));
        return syncInfo;
    }

    protected SVNMergeStatus getStatusFor(IResource resource) {
        SVNMergeStatus[] statuses = this.mergeScopeHelper.getMergeSet().getStatuses();
        IPath target = FileUtility.getResourcePath(resource);
        int i = 0;
        while (i < statuses.length) {
            if (target.equals((Object)new Path(statuses[i].path))) {
                return statuses[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    protected IRemoteStatusOperation addStatusOperation(CompositeOperation op, IResource[] resources, int depth) {
        this.mergeStatusOp = this.mergeScopeHelper == null ? null : new MergeStatusOperation(this.mergeScopeHelper.getMergeSet(), resources);
        MergeStatusOperation mergeOp = this.mergeStatusOp;
        if (mergeOp == null) {
            return null;
        }
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add(saveOp);
        op.add(mergeOp);
        op.add(new RestoreProjectMetaOperation(saveOp));
        op.add(new RefreshResourcesOperation(resources, depth, RefreshResourcesOperation.REFRESH_CHANGES));
        return mergeOp;
    }

    @Override
    protected HashSet<IResource> clearRemoteStatusesImpl(IResource[] resources) throws TeamException {
        this.clearRemoteStatusesImpl(this.baseStatusCache, resources);
        return super.clearRemoteStatusesImpl(resources);
    }

    @Override
    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        if (this.mergeScopeHelper != null) {
            this.baseStatusCache.clearAll();
            this.mergeScopeHelper.getMergeSet().setStatuses(new SVNMergeStatus[0]);
        }
        super.refresh(resources, depth, monitor);
    }

    @Override
    protected IResourceChange handleResourceChange(IRemoteStatusOperation rStatusOp, SVNEntryStatus status) {
        final SVNMergeStatus current = (SVNMergeStatus)status;
        IChangeStateProvider endProvider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.date;
            }

            public String getChangeAuthor() {
                return current.author;
            }

            public SVNRevision.Number getChangeRevision() {
                return current.endRevision == -1L ? null : SVNRevision.fromNumber(current.endRevision);
            }

            public SVNEntryStatus.Kind getTextChangeType() {
                return current.textStatus;
            }

            public SVNEntryStatus.Kind getPropertiesChangeType() {
                return current.propStatus;
            }

            public SVNEntry.Kind getNodeKind() {
                SVNEntry.Kind kind = SVNUtility.getNodeKind(current.path, current.nodeKind, true);
                return kind == SVNEntry.Kind.NONE && !current.hasTreeConflict ? SVNUtility.getNodeKind(current.path, current.nodeKind, false) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return current.comment;
            }

            public boolean isCopied() {
                return false;
            }

            public boolean isSwitched() {
                return false;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf(MergeSubscriber.this.mergeScopeHelper.getRoots(), set);
            }

            public SVNConflictDescriptor getTreeConflictDescriptor() {
                return current.treeConflictDescriptor;
            }
        };
        if (endProvider.getNodeKind() == SVNEntry.Kind.NONE && !current.hasTreeConflict) {
            return null;
        }
        IResourceChange endResourceChange = SVNRemoteStorage.instance().asResourceChange(endProvider, false);
        if (endResourceChange == null) {
            return null;
        }
        if (endResourceChange.getRevision() != -1L) {
            IRepositoryResource originator = this.getEndOriginator();
            String decodedUrl = SVNUtility.decodeURL(current.endUrl);
            originator = endProvider.getNodeKind() == SVNEntry.Kind.DIR ? originator.asRepositoryContainer(decodedUrl, false) : originator.asRepositoryFile(decodedUrl, false);
            originator.setSelectedRevision(SVNRevision.fromNumber(current.textStatus == SVNEntryStatus.Kind.DELETED ? current.endRevision - 1L : current.endRevision));
            endResourceChange.setOriginator(originator);
        }
        IChangeStateProvider startProvider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.date;
            }

            public String getChangeAuthor() {
                return null;
            }

            public SVNRevision.Number getChangeRevision() {
                return current.startRevision == -1L ? null : SVNRevision.fromNumber(current.startRevision);
            }

            public SVNEntryStatus.Kind getTextChangeType() {
                return current.startRevision == -1L ? SVNEntryStatus.Kind.NONE : SVNEntryStatus.Kind.NORMAL;
            }

            public SVNEntryStatus.Kind getPropertiesChangeType() {
                return SVNEntryStatus.Kind.NONE;
            }

            public SVNEntry.Kind getNodeKind() {
                SVNEntry.Kind kind = SVNUtility.getNodeKind(current.path, current.nodeKind, true);
                return kind == SVNEntry.Kind.NONE && !current.hasTreeConflict ? SVNUtility.getNodeKind(current.path, current.nodeKind, false) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return null;
            }

            public boolean isCopied() {
                return false;
            }

            public boolean isSwitched() {
                return false;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf(MergeSubscriber.this.mergeScopeHelper.getRoots(), set);
            }

            public SVNConflictDescriptor getTreeConflictDescriptor() {
                return current.treeConflictDescriptor;
            }
        };
        IResourceChange startResourceChange = SVNRemoteStorage.instance().asResourceChange(startProvider, false);
        if (startResourceChange.getRevision() != -1L) {
            String decodedUrl = SVNUtility.decodeURL(current.startUrl);
            IRepositoryResource originator = this.getStartOriginator();
            originator = startProvider.getNodeKind() == SVNEntry.Kind.DIR ? originator.asRepositoryContainer(decodedUrl, false) : originator.asRepositoryFile(decodedUrl, false);
            originator.setSelectedRevision(SVNRevision.fromNumber(current.startRevision));
            startResourceChange.setOriginator(originator);
        }
        try {
            this.baseStatusCache.setBytes(startResourceChange.getResource(), SVNRemoteStorage.instance().resourceChangeAsBytes(startResourceChange));
        }
        catch (TeamException e) {
            LoggedOperation.reportError(this.getClass().getName(), e);
        }
        return endResourceChange;
    }

    protected IRepositoryResource getEndOriginator() {
        AbstractMergeSet mergeSet = this.mergeScopeHelper.getMergeSet();
        if (mergeSet instanceof MergeSet1URL) {
            return ((MergeSet1URL)mergeSet).from[0];
        }
        if (mergeSet instanceof MergeSet2URL) {
            return ((MergeSet2URL)mergeSet).fromEnd[0];
        }
        return ((MergeSetReintegrate)mergeSet).from[0];
    }

    protected IRepositoryResource getStartOriginator() {
        AbstractMergeSet mergeSet = this.mergeScopeHelper.getMergeSet();
        if (mergeSet instanceof MergeSet1URL) {
            return ((MergeSet1URL)mergeSet).from[0];
        }
        if (mergeSet instanceof MergeSet2URL) {
            return ((MergeSet2URL)mergeSet).fromStart[0];
        }
        return ((MergeSetReintegrate)mergeSet).from[0];
    }

    @Override
    protected boolean isIncoming(SVNEntryStatus status) {
        return true;
    }

    private MergeSubscriber() {
        super(false, SVNMessages.MergeSubscriber_Name);
    }
}

