/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsArray<T>
extends TypeSafeMatcher<T[]> {
    private final Matcher<T>[] elementMatchers;

    public IsArray(Matcher<T>[] elementMatchers) {
        this.elementMatchers = (Matcher[])elementMatchers.clone();
    }

    @Override
    public boolean matchesSafely(T[] array) {
        if (array.length != this.elementMatchers.length) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (this.elementMatchers[i].matches(array[i])) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendList(this.descriptionStart(), this.descriptionSeparator(), this.descriptionEnd(), Arrays.asList(this.elementMatchers));
    }

    protected String descriptionStart() {
        return "[";
    }

    protected String descriptionSeparator() {
        return ", ";
    }

    protected String descriptionEnd() {
        return "]";
    }

    public static <T> IsArray<T> array(Matcher<T> ... elementMatchers) {
        return new IsArray<T>(elementMatchers);
    }
}

