/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.ResourceUtils;
import org.eclipse.titan.executor.Activator;
import org.eclipse.titan.executor.properties.PropertyStore;
import org.eclipse.ui.IWorkbenchPropertyPage;

public abstract class FieldEditorPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private IAdaptable element;
    private IPreferenceStore overlayStore;
    private final List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private static final String USE_PROJECT_SETTINGS = "useProjectSettings";
    private Button useWorkspaceSettingsButton;
    private Button useProjectSettingsButton;
    private Button configureButton;
    private ImageDescriptor image;
    private String pageId;

    protected FieldEditorPropertyPage(int style) {
        super(style);
    }

    public FieldEditorPropertyPage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
        this.image = image;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected void resetPreferenceStore() {
        this.overlayStore = new PropertyStore((IResource)this.getElement(), Activator.getDefault().getPreferenceStore(), this.getPageId());
    }

    protected abstract String getPageId();

    protected Control createContents(Composite parent) {
        if (this.isPropertyPage()) {
            this.createSelectionGroup(parent);
        }
        return super.createContents(parent);
    }

    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            this.pageId = this.getPageId();
            this.overlayStore = new PropertyStore((IResource)this.getElement(), super.getPreferenceStore(), this.pageId);
        }
        super.createControl(parent);
        this.updateFieldEditors();
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.isPropertyPage()) {
            return this.overlayStore;
        }
        return super.getPreferenceStore();
    }

    private void createSelectionGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        Composite radioGroup = new Composite(comp, 0);
        radioGroup.setLayout((Layout)new GridLayout());
        radioGroup.setLayoutData((Object)new GridData(768));
        this.useWorkspaceSettingsButton = this.createRadioButton(radioGroup, "Use workspace settings");
        this.useProjectSettingsButton = this.createRadioButton(radioGroup, "Use project settings");
        this.configureButton = new Button(comp, 8);
        this.configureButton.setText("Configure Workspace Settings ...");
        this.configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorPropertyPage.this.configureWorkspaceSettings();
            }
        });
        try {
            String use = ((IResource)this.element).getPersistentProperty(new QualifiedName(this.pageId, USE_PROJECT_SETTINGS));
            if ("true".equals(use)) {
                this.useProjectSettingsButton.setSelection(true);
                this.configureButton.setEnabled(false);
            } else {
                this.useWorkspaceSettingsButton.setSelection(true);
            }
        }
        catch (CoreException e) {
            this.useWorkspaceSettingsButton.setSelection(true);
        }
    }

    private Button createRadioButton(Composite parent, String label) {
        final Button button = new Button(parent, 16);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorPropertyPage.this.configureButton.setEnabled(button == FieldEditorPropertyPage.this.useWorkspaceSettingsButton);
                FieldEditorPropertyPage.this.updateFieldEditors();
            }
        });
        return button;
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    protected void checkState() {
        super.checkState();
        boolean valid = true;
        if (this.editors != null) {
            for (FieldEditor editor : this.editors) {
                if (valid = valid && editor.isValid()) continue;
                break;
            }
        }
        this.setValid(valid);
    }

    protected void performDefaults() {
        if (this.isPropertyPage()) {
            this.useWorkspaceSettingsButton.setSelection(true);
            this.useProjectSettingsButton.setSelection(false);
            this.configureButton.setEnabled(true);
            this.updateFieldEditors();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result && this.isPropertyPage()) {
            IResource resource = (IResource)this.element;
            try {
                String value = this.useProjectSettingsButton.getSelection() ? "true" : "false";
                resource.setPersistentProperty(new QualifiedName(this.pageId, USE_PROJECT_SETTINGS), value);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else {
                this.setValid(newValue);
            }
        }
    }

    protected void updateFieldEditors() {
        if (!this.isPropertyPage()) {
            return;
        }
        boolean projectSettings = this.useProjectSettingsButton.getSelection();
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.setEnabled(projectSettings, parent);
        }
    }

    protected void configureWorkspaceSettings() {
        try {
            IPreferencePage page = (IPreferencePage)((Object)((Object)this)).getClass().newInstance();
            page.setTitle(this.getTitle());
            page.setImageDescriptor(this.image);
            this.showPreferencePage(this.pageId, page);
        }
        catch (InstantiationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        catch (IllegalAccessException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    protected void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode){
            final /* synthetic */ IPreferenceNode val$targetNode;
            {
                this.val$targetNode = iPreferenceNode;
            }

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                dialog.open();
            }
        });
    }

    protected List<FieldEditor> getFieldEditors() {
        return this.editors;
    }

    protected boolean isProjectSettingsSelected() {
        return this.useProjectSettingsButton != null && this.useProjectSettingsButton.getSelection();
    }

    public boolean isPropertyPage() {
        return this.element != null;
    }

    public static String getOverlayedPreferenceValue(IPreferenceStore store, IResource resource, String pageId, String name) {
        IProject project = resource.getProject();
        String value = null;
        if (FieldEditorPropertyPage.useProjectSettings((IResource)project, pageId)) {
            value = ResourceUtils.getPersistentProperty((IResource)resource, (String)pageId, (String)name);
        }
        if (value != null) {
            return value;
        }
        return store.getString(name);
    }

    private static boolean useProjectSettings(IResource resource, String pageId) {
        String use = ResourceUtils.getPersistentProperty((IResource)resource, (String)pageId, (String)USE_PROJECT_SETTINGS);
        return "true".equals(use);
    }
}

