/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.graph.gui.windows.ModuleGraphEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class ModuleGraphAction
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        this.doOpenModuleGraph();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doOpenModuleGraph();
        return null;
    }

    private void doOpenModuleGraph() {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        for (Object selected : structSelection.toList()) {
            if (!(selected instanceof IProject)) continue;
            IProject project = (IProject)selected;
            Generator generator = new Generator(project);
            generator.schedule();
        }
    }

    private static class Generator
    extends Job {
        private final IProject project;

        Generator(IProject project) {
            super("Generator");
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Parsing project", 30);
            IFile input = null;
            try {
                IResource[] members;
                for (IResource res : members = this.project.members()) {
                    if (res.getType() == 1) {
                        input = (IFile)res;
                        break;
                    }
                    if (res.getType() != 2) continue;
                    members = ((IFolder)res).members();
                }
            }
            catch (CoreException ce) {
                GUIErrorHandler errorHandler = new GUIErrorHandler();
                errorHandler.reportException("Error while parsing the project", (Exception)((Object)ce));
            }
            final IFile finalInput = input;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        FileEditorInput editorInput = new FileEditorInput(finalInput);
                        IEditorPart editor = page.findEditor((IEditorInput)editorInput);
                        if (editor instanceof ModuleGraphEditor) {
                            ((ModuleGraphEditor)editor).refreshGraph();
                        } else {
                            page.openEditor((IEditorInput)editorInput, "org.eclipse.titanium.graph.editors.ModuleGraphEditor", true, 3);
                        }
                    }
                    catch (Exception exc) {
                        GUIErrorHandler errorHandler = new GUIErrorHandler();
                        errorHandler.reportException("Error whlie parsing the project", exc);
                    }
                }
            });
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

