/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.titanium.graph.clustering.ClusteringTools;
import org.eclipse.titanium.graph.clustering.FolderNameCluster;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public class ModuleLocationCluster
extends FolderNameCluster {
    public ModuleLocationCluster(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph, IProject project) {
        super(graph, project);
    }

    @Override
    protected void checkFile(IFile file, Set<NodeDescriptor> cluster) {
        String name = this.parser.containedModuleName(file);
        if (name == null) {
            return;
        }
        if (file.isLinked()) {
            this.checkLinkedFile(name, "Linked from " + ClusteringTools.truncate(file.getLocation().removeLastSegments(1).toOSString()));
        } else {
            this.addNodeToCluster(name, cluster);
        }
    }

    protected void checkLinkedFile(String filename, String clustername) {
        if (this.mapNameCluster.containsKey(clustername)) {
            Set cluster = (Set)this.mapNameCluster.get(clustername);
            this.addNodeToCluster(filename, cluster);
        } else {
            HashSet<NodeDescriptor> cluster = new HashSet<NodeDescriptor>();
            this.addNodeToCluster(filename, cluster);
            this.clusters.add(cluster);
            this.mapNameCluster.put(clustername, cluster);
        }
    }

    @Override
    protected void addNewCluster(Set<NodeDescriptor> cluster, IFolder folder) {
        if (!cluster.isEmpty()) {
            this.clusters.add(cluster);
            if (folder.isLinked()) {
                this.mapNameCluster.put("Linked from " + ClusteringTools.truncate(folder.getLocation().toOSString()), cluster);
            } else {
                this.mapNameCluster.put(folder.getProjectRelativePath().toOSString(), cluster);
            }
        }
    }

    @Override
    protected String getType() {
        return "Clustering by module location";
    }
}

