/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignments;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.Defined_Reference;
import org.eclipse.titan.designer.AST.ASN1.Type_Assignment;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NameReStarter;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;
import org.eclipse.titan.designer.parsers.asn1parser.FormalParameter_Helper;
import org.eclipse.titan.designer.parsers.asn1parser.TokenWithIndexAndSubTokens;

public final class Parameterised_Reference
extends Defined_Reference {
    private static final String FULLNAMEPART1 = ".<block>";
    private static final String FULLNAMEPART2 = "{}";
    private static final String ASSIGNMENTEXPECTED = "ASN.1 assignment expected";
    private static final String PARAMETERISEDASSIGNMENTEXPECTED = "Parameterized assignment expected";
    private static final String DIFFERENTPARAMETERNUMBERS = "Too {0} parameters: `{1}'' was expected instead of `{2}''";
    private final Block mBlock;
    private final Defined_Reference assignmentReference;
    private boolean isErroneous;
    private ASN1Assignments assignments;
    private Defined_Reference finalReference;
    private CompilationTimeStamp lastCheckTimeStamp;
    private NameReStarter newAssignmentNameStart;
    private Location location;
    private Assignment oldParass = null;
    private ASN1Assignment oldDynamicAssignment = null;

    public Parameterised_Reference(Defined_Reference reference, Block aBlock) {
        super(null);
        this.assignmentReference = reference;
        this.isErroneous = false;
        this.mBlock = aBlock;
        this.assignmentReference.setFullNameParent(this);
        if (null != aBlock) {
            aBlock.setFullNameParent(this);
        }
    }

    @Override
    public Parameterised_Reference newInstance() {
        Parameterised_Reference temp = null;
        temp = new Parameterised_Reference(this.assignmentReference.newInstance(), this.mBlock);
        temp.setLocation(new Location(this.location));
        return temp;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.assignmentReference.setMyScope(scope);
    }

    @Override
    public Identifier getId() {
        Defined_Reference ref = this.getRefDefdSimple();
        if (null != ref) {
            return ref.getId();
        }
        return null;
    }

    @Override
    public Identifier getModuleIdentifier() {
        Defined_Reference ref = this.getRefDefdSimple();
        if (null != ref) {
            return ref.getModuleIdentifier();
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        this.getRefDefdSimple();
        if (null != this.finalReference) {
            return this.finalReference.getDisplayName();
        }
        return this.assignmentReference.getDisplayName() + FULLNAMEPART2;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.mBlock == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.assignments == child) {
            return builder.append(".").append(this.assignmentReference.getFullName()).append(FULLNAMEPART2);
        }
        return builder;
    }

    public Defined_Reference getRefDefdSimple() {
        Module module = this.myScope.getModuleScope();
        CompilationTimeStamp compilationTimeStamp = module.getLastImportationCheckTimeStamp();
        if (compilationTimeStamp == null) {
            return null;
        }
        if (null != this.lastCheckTimeStamp && !this.lastCheckTimeStamp.isLess(compilationTimeStamp)) {
            if (this.isErroneous) {
                return null;
            }
            return this.finalReference;
        }
        this.lastCheckTimeStamp = compilationTimeStamp;
        Assignment parass = this.assignmentReference.getRefdAssignment(compilationTimeStamp, true, null);
        if (this.oldParass == parass && parass != null) {
            ((ASN1Assignment)parass).getAssPard().newInstanceNumber(this.myScope.getModuleScopeGen());
            ((ASN1Assignments)module.getAssignments()).removeDynamicAssignment(this.oldDynamicAssignment);
            ((ASN1Assignments)module.getAssignments()).addDynamicAssignment(compilationTimeStamp, this.oldDynamicAssignment);
            this.oldDynamicAssignment.setMyScope(this.assignments);
            this.oldDynamicAssignment.check(compilationTimeStamp);
            return this.finalReference;
        }
        this.oldParass = parass;
        if (null == parass) {
            this.isErroneous = true;
            return null;
        }
        if (!(parass instanceof ASN1Assignment)) {
            this.assignmentReference.getLocation().reportSemanticError(ASSIGNMENTEXPECTED);
            this.isErroneous = true;
            return null;
        }
        Ass_pard assPard = ((ASN1Assignment)parass).getAssPard();
        if (null == assPard) {
            this.assignmentReference.getLocation().reportSemanticError(PARAMETERISEDASSIGNMENTEXPECTED);
            this.isErroneous = true;
            return this.assignmentReference;
        }
        this.addAssignments(assPard, compilationTimeStamp);
        ASN1Assignment newAssignment = ((ASN1Assignment)parass).newInstance(this.myScope.getModuleScopeGen());
        String newAssignmentDisplayname = newAssignment.getIdentifier().getDisplayName();
        this.assignments.setRightScope(this.myScope);
        this.assignments.setParentScope(parass.getMyScope());
        this.assignments.setParentScopeGen(this.myScope);
        this.assignments.setScopeName(newAssignmentDisplayname);
        this.assignments.setFullNameParent(this);
        this.assignments.check(compilationTimeStamp);
        this.newAssignmentNameStart = new NameReStarter(module.getFullName() + "." + newAssignmentDisplayname);
        this.newAssignmentNameStart.setFullNameParent(parass);
        newAssignment.setFullNameParent(this.newAssignmentNameStart);
        newAssignment.setLocation(this.location);
        newAssignment.getIdentifier().setLocation(this.assignmentReference.getLocation());
        ((ASN1Assignments)module.getAssignments()).removeDynamicAssignment(this.oldDynamicAssignment);
        ((ASN1Assignments)module.getAssignments()).addDynamicAssignment(compilationTimeStamp, newAssignment);
        newAssignment.setMyScope(this.assignments);
        newAssignment.setDontGenerate();
        newAssignment.check(compilationTimeStamp);
        this.oldDynamicAssignment = newAssignment;
        ArrayList<ISubReference> subreferences = new ArrayList<ISubReference>(1);
        subreferences.add(new FieldSubReference(newAssignment.getIdentifier()));
        this.finalReference = new Defined_Reference(module.getIdentifier(), subreferences);
        this.finalReference.setFullNameParent(this);
        this.finalReference.setMyScope(module);
        return this.finalReference;
    }

    private void addAssignments(Ass_pard aAssPard, CompilationTimeStamp aCompilationTimeStamp) {
        int nofActualParameters;
        if (null == this.mBlock) {
            return;
        }
        List<FormalParameter_Helper> formalParameters = aAssPard.getFormalParameters(aCompilationTimeStamp);
        int nofFormalParameters = formalParameters.size();
        ArrayList actualParameters = new ArrayList();
        ArrayList<Object> temporalBuffer = new ArrayList<Object>();
        List<Token> unprocessParameters = this.mBlock.getTokenList();
        int beginChars = 0;
        block5: for (int i = 0; i < unprocessParameters.size(); ++i) {
            Token tempToken = unprocessParameters.get(i);
            switch (tempToken.getType()) {
                case 110: {
                    ++beginChars;
                    temporalBuffer.add(tempToken);
                    continue block5;
                }
                case 111: {
                    --beginChars;
                    temporalBuffer.add(tempToken);
                    continue block5;
                }
                case 116: {
                    if (beginChars == 0) {
                        temporalBuffer.add((Object)new TokenWithIndexAndSubTokens(-1));
                        actualParameters.add(temporalBuffer);
                        temporalBuffer = new ArrayList();
                        continue block5;
                    }
                    temporalBuffer.add(tempToken);
                    continue block5;
                }
                default: {
                    temporalBuffer.add(tempToken);
                }
            }
        }
        if (!temporalBuffer.isEmpty()) {
            temporalBuffer.add((Object)new TokenWithIndexAndSubTokens(-1));
            actualParameters.add(temporalBuffer);
        }
        if ((nofActualParameters = actualParameters.size()) != nofFormalParameters) {
            this.location.reportSemanticError(MessageFormat.format(DIFFERENTPARAMETERNUMBERS, nofActualParameters < nofFormalParameters ? "few" : "many", nofFormalParameters, nofActualParameters));
        }
        this.assignments = new ASN1Assignments();
        for (int i = 0; i < nofFormalParameters; ++i) {
            Identifier identifier = formalParameters.get((int)i).identifier;
            Assignment temporalAssignment = null;
            if (i < nofActualParameters) {
                ArrayList<Token> temporalTokenBuffer = new ArrayList<Token>();
                temporalTokenBuffer.add(formalParameters.get((int)i).formalParameterToken);
                Token temporalToken = formalParameters.get((int)i).governorToken;
                if (null != temporalToken) {
                    temporalTokenBuffer.add(temporalToken);
                }
                temporalTokenBuffer.add((Token)new TokenWithIndexAndSubTokens(104));
                temporalTokenBuffer.addAll((Collection)actualParameters.get(i));
                Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(new Block(temporalTokenBuffer, this.location));
                if (null != parser) {
                    temporalAssignment = parser.pr_special_Assignment().assignment;
                    List<SyntacticErrorStorage> errors = parser.getErrorStorage();
                    if (null != errors && !errors.isEmpty()) {
                        this.isErroneous = true;
                        temporalAssignment = null;
                        for (int j = 0; j < errors.size(); ++j) {
                            ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(j), 2);
                        }
                    }
                }
            }
            if (null == temporalAssignment) {
                temporalAssignment = new Type_Assignment(identifier, null, null);
            }
            temporalAssignment.setLocation(this.location);
            this.assignments.addAssignment(temporalAssignment);
        }
        for (List list : actualParameters) {
            list.clear();
        }
        actualParameters.clear();
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.assignmentReference != null && !this.assignmentReference.accept(v)) {
            return false;
        }
        if (this.assignments != null && !this.assignments.accept(v)) {
            return false;
        }
        return this.finalReference == null || this.finalReference.accept(v);
    }
}

