/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_FunctionBase;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class FunctionTypeMappingTarget
extends TypeMappingTarget {
    private static final String FULLNAMEPART1 = ".<target_type>";
    private static final String FULLNAMEPART2 = ".<function_ref>";
    private final Type targetType;
    private final Reference functionReference;
    private Def_Function functionReferenced;
    private Def_Extfunction extfunctionReferenced;

    public FunctionTypeMappingTarget(Type targetType, Reference functionReference) {
        this.targetType = targetType;
        this.functionReference = functionReference;
        if (targetType != null) {
            targetType.setFullNameParent(this);
        }
    }

    @Override
    public TypeMappingTarget.TypeMapping_type getTypeMappingType() {
        return TypeMappingTarget.TypeMapping_type.FUNCTION;
    }

    @Override
    public String getMappingName() {
        return "function";
    }

    @Override
    public Type getTargetType() {
        return this.targetType;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.targetType == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.functionReference == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.targetType != null) {
            this.targetType.setMyScope(scope);
        }
        if (this.functionReference != null) {
            this.functionReference.setMyScope(scope);
        }
    }

    public Def_Function getFunction() {
        return this.functionReferenced;
    }

    public Def_Extfunction getExternalFunction() {
        return this.extfunctionReferenced;
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Type sourceType, Port_Type portType, boolean legacy, boolean incoming) {
        String message;
        Type outputType;
        Type inputType;
        Def_FunctionBase.EncodingPrototype_type referencedPrototype;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.functionReferenced = null;
        this.extfunctionReferenced = null;
        if (this.functionReference == null) {
            return;
        }
        Assignment assignment = this.functionReference.getRefdAssignment(timestamp, false);
        if (assignment == null) {
            return;
        }
        assignment.check(timestamp);
        switch (assignment.getAssignmentType()) {
            case A_FUNCTION: 
            case A_FUNCTION_RVAL: 
            case A_FUNCTION_RTEMP: {
                this.functionReferenced = (Def_Function)assignment;
                referencedPrototype = this.functionReferenced.getPrototype();
                inputType = this.functionReferenced.getInputType();
                outputType = this.functionReferenced.getOutputType();
                break;
            }
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RTEMP: {
                if (legacy) {
                    this.extfunctionReferenced = (Def_Extfunction)assignment;
                    referencedPrototype = this.extfunctionReferenced.getPrototype();
                    inputType = this.extfunctionReferenced.getInputType();
                    outputType = this.extfunctionReferenced.getOutputType();
                    break;
                }
                this.functionReference.getLocation().reportSemanticError(MessageFormat.format("Reference to a function was expected instead of {0}", assignment.getDescription()));
                return;
            }
            default: {
                this.functionReference.getLocation().reportSemanticError(MessageFormat.format("Reference to a function or external function was expected instead of {0}", assignment.getDescription()));
                return;
            }
        }
        if (legacy && Def_FunctionBase.EncodingPrototype_type.NONE.equals((Object)referencedPrototype)) {
            this.functionReference.getLocation().reportSemanticError(MessageFormat.format("The referenced {0} does not have `prototype'' attribute", assignment.getDescription()));
            return;
        }
        if (!legacy && !Def_FunctionBase.EncodingPrototype_type.FAST.equals((Object)referencedPrototype)) {
            this.functionReference.getLocation().reportSemanticError(MessageFormat.format("The referenced {0} does not have `prototype'' fast attribute", assignment.getDescription()));
            return;
        }
        if (legacy && inputType != null && sourceType != null && !sourceType.isIdentical(timestamp, inputType)) {
            message = MessageFormat.format("The input type of {0} must be the same as the source type of the mapping: `{1}'' was expected instead of `{2}''", assignment.getDescription(), sourceType.getTypename(), inputType.getTypename());
            sourceType.getLocation().reportSemanticError(message);
        }
        if (legacy && outputType != null && !this.targetType.isIdentical(timestamp, outputType)) {
            message = MessageFormat.format("The output type of {0} must be the same as the target type of the mapping: `{1}'' was expected instead of `{2}''", assignment.getDescription(), this.targetType.getTypename(), outputType.getTypename());
            this.targetType.getLocation().reportSemanticError(message);
        }
        if (!legacy) {
            if (incoming) {
                if (inputType != null && !this.targetType.isIdentical(timestamp, inputType)) {
                    message = MessageFormat.format("The input type of {0} must be the same as the source type of the mapping: `{1}'' was expected instead of `{2}''", assignment.getDescription(), this.targetType.getTypename(), inputType.getTypename());
                    this.targetType.getLocation().reportSemanticError(message);
                }
                if (outputType != null && !sourceType.isIdentical(timestamp, outputType)) {
                    message = MessageFormat.format("The output type of {0} must be the same as the target type of the mapping: `{1}'' was expected instead of `{2}''", assignment.getDescription(), sourceType.getTypename(), outputType.getTypename());
                    this.targetType.getLocation().reportSemanticError(message);
                }
            } else {
                if (inputType != null && !sourceType.isIdentical(timestamp, inputType)) {
                    message = MessageFormat.format("The input type of {0} must be the same as the source type of the mapping: `{1}'' was expected instead of `{2}''", assignment.getDescription(), sourceType.getTypename(), inputType.getTypename());
                    this.targetType.getLocation().reportSemanticError(message);
                }
                if (outputType != null && !this.targetType.isIdentical(timestamp, outputType)) {
                    message = MessageFormat.format("The output type of {0} must be the same as the target type of the mapping: `{1}'' was expected instead of `{2}''", assignment.getDescription(), this.targetType.getTypename(), outputType.getTypename());
                    this.targetType.getLocation().reportSemanticError(message);
                }
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.targetType != null) {
            this.targetType.updateSyntax(reparser, false);
            reparser.updateLocation(this.targetType.getLocation());
        }
        if (this.functionReference != null) {
            this.functionReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.functionReference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.targetType != null) {
            this.targetType.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.functionReference != null) {
            this.functionReference.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.targetType != null && !this.targetType.accept(v)) {
            return false;
        }
        return this.functionReference == null || this.functionReference.accept(v);
    }

    @Override
    public PortGenerator.MessageTypeMappingTarget fillTypeMappingTarget(JavaGenData aData, StringBuilder source, IType sourceType, AtomicBoolean hasSliding) {
        Def_FunctionBase.EncodingPrototype_type prototype_type;
        String functionDisplayName;
        String functionName;
        String targetTypeName = null;
        String displayName = null;
        hasSliding.set(false);
        if (this.targetType != null) {
            targetTypeName = this.targetType.getGenNameValue(aData, source);
            displayName = this.targetType.getTypename();
        }
        PortGenerator.FunctionPrototype_Type prototype = null;
        if (this.functionReferenced != null) {
            functionName = this.functionReferenced.getGenNameFromScope(aData, source, "");
            functionDisplayName = this.functionReferenced.getFullName();
            prototype_type = this.functionReferenced.getPrototype();
        } else {
            functionName = this.extfunctionReferenced.getGenNameFromScope(aData, source, "");
            functionDisplayName = this.extfunctionReferenced.getFullName();
            prototype_type = this.extfunctionReferenced.getPrototype();
        }
        switch (prototype_type) {
            case CONVERT: {
                prototype = PortGenerator.FunctionPrototype_Type.CONVERT;
                break;
            }
            case FAST: {
                prototype = PortGenerator.FunctionPrototype_Type.FAST;
                break;
            }
            case BACKTRACK: {
                prototype = PortGenerator.FunctionPrototype_Type.BACKTRACK;
                break;
            }
            case SLIDING: {
                prototype = PortGenerator.FunctionPrototype_Type.SLIDING;
                hasSliding.set(true);
                break;
            }
        }
        return new PortGenerator.MessageTypeMappingTarget(targetTypeName, displayName, functionName, functionDisplayName, prototype);
    }
}

