/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import org.eclipse.titan.designer.compiler.JavaGenData;

public final class UniversalChar {
    private final int group;
    private final int plane;
    private final int row;
    private final int cell;

    public UniversalChar(int group, int plane, int row, int cell) {
        this.group = group;
        this.plane = plane;
        this.row = row;
        this.cell = cell;
    }

    public UniversalChar(int codePoint) {
        this.cell = codePoint & 0xFF;
        this.row = codePoint >> 8 & 0xFF;
        this.plane = codePoint >> 16 & 0xFF;
        this.group = codePoint >> 24 & 0xFF;
    }

    public int toCodePoint() {
        return (this.group << 24) + (this.plane << 16) + (this.row << 8) + this.cell;
    }

    public int group() {
        return this.group;
    }

    public int plane() {
        return this.plane;
    }

    public int row() {
        return this.row;
    }

    public int cell() {
        return this.cell;
    }

    public boolean isChar() {
        return this.group == 0 && this.plane == 0 && this.row == 0;
    }

    public boolean isValidChar() {
        return this.isChar() && this.cell < 128;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isChar() && this.cell >= 32 && this.cell <= 127) {
            sb.append('\"');
            sb.append((char)this.cell);
            sb.append('\"');
        } else {
            sb.append("char(").append(this.group).append(',').append(this.plane).append(',').append(this.row).append(',').append(this.cell).append(')');
        }
        return sb.toString();
    }

    public int compareWith(UniversalChar other) {
        if (this == other) {
            return 0;
        }
        if (this.group > other.group()) {
            return 1;
        }
        if (this.group < other.group()) {
            return -1;
        }
        if (this.plane > other.plane()) {
            return 1;
        }
        if (this.plane < other.plane()) {
            return -1;
        }
        if (this.row > other.row()) {
            return 1;
        }
        if (this.row < other.row()) {
            return -1;
        }
        if (this.cell > other.cell()) {
            return 1;
        }
        if (this.cell < other.cell()) {
            return -1;
        }
        return 0;
    }

    public boolean checkEquality(UniversalChar other) {
        if (this == other) {
            return true;
        }
        return this.group == other.group && this.plane == other.plane && this.row == other.row && this.cell == other.cell;
    }

    public boolean checkEquality(char other) {
        return this.group == 0 && this.plane == 0 && this.row == 0 && this.cell == other;
    }

    public int hashCode() {
        int h = this.group;
        h = 31 * h + this.plane;
        h = 31 * h + this.row;
        h = 31 * h + this.cell;
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UniversalChar) {
            return this.checkEquality((UniversalChar)obj);
        }
        return false;
    }

    public StringBuilder generateSingleExpression(JavaGenData aData) {
        aData.addBuiltinTypeImport("TitanUniversalChar");
        StringBuilder result = new StringBuilder();
        result.append("new TitanUniversalChar( ");
        result.append("(char) ").append(this.group).append(", ");
        result.append("(char) ").append(this.plane).append(", ");
        result.append("(char) ").append(this.row).append(", ");
        result.append("(char) ").append(this.cell);
        result.append(" )");
        return result;
    }
}

