/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.CharString_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeFactory;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class Value
extends GovernedSimple
implements IReferenceChainElement,
IValue,
IIncrementallyUpdateable {
    protected IType myGovernor;
    protected IType myLastSetGovernor;

    @Override
    public ISetting.Setting_type getSettingtype() {
        return ISetting.Setting_type.S_V;
    }

    @Override
    public final void copyGeneralProperties(IValue original) {
        this.location = original.getLocation();
        super.setFullNameParent(original.getNameParent());
        this.myGovernor = original.getMyGovernor();
        this.myLastSetGovernor = original.getMyGovernor();
        this.setMyScope(original.getMyScope());
    }

    @Override
    public abstract IValue.Value_type getValuetype();

    @Override
    public final IType getMyGovernor() {
        return this.myGovernor;
    }

    @Override
    public final void setMyGovernor(IType governor) {
        this.myGovernor = governor;
        if (governor != null) {
            this.myLastSetGovernor = governor;
        }
    }

    @Override
    public final CompilationTimeStamp getLastTimeChecked() {
        return this.lastTimeChecked;
    }

    @Override
    public final void setLastTimeChecked(CompilationTimeStamp lastTimeChecked) {
        this.lastTimeChecked = lastTimeChecked;
    }

    @Override
    public String chainedDescription() {
        return this.getFullName();
    }

    @Override
    public Location getChainLocation() {
        return this.location;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType type = this.getMyGovernor();
        if (type == null) {
            type = TypeFactory.createType(this.getExpressionReturntype(timestamp, expectedValue));
        }
        return type;
    }

    @Override
    public final boolean isUnfoldable(CompilationTimeStamp timestamp) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        boolean result = this.isUnfoldable(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, referenceChain);
        referenceChain.release();
        return result;
    }

    @Override
    public final boolean isUnfoldable(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        return this.isUnfoldable(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, referenceChain);
    }

    @Override
    public abstract boolean isUnfoldable(CompilationTimeStamp var1, Expected_Value_type var2, IReferenceChain var3);

    @Override
    public abstract IValue getReferencedSubValue(CompilationTimeStamp var1, Reference var2, int var3, IReferenceChain var4);

    public boolean checkStringEncoding(CompilationTimeStamp timestamp, Assignment lhs) {
        this.setLoweridToReference(timestamp);
        boolean selfReference = new CharString_Type().checkThisValue(timestamp, this, lhs, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, false, false, false));
        if (!this.isUnfoldable(timestamp)) {
            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IValue last = this.getValueRefdLast(timestamp, referenceChain);
            referenceChain.release();
            if (last.getValuetype() == IValue.Value_type.CHARSTRING_VALUE) {
                String encodingName = ((Charstring_Value)last).getValue();
                if (!("UTF-8".equals(encodingName) || "UTF-16".equals(encodingName) || "UTF-16LE".equals(encodingName) || "UTF-16BE".equals(encodingName) || "UTF-32".equals(encodingName) || "UTF-32LE".equals(encodingName) || "UTF-32BE".equals(encodingName))) {
                    this.getLocation().reportSemanticError(MessageFormat.format("`{0}'' is not a valid encoding format", encodingName));
                }
            } else {
                this.getLocation().reportSemanticError("Cannot use this value in charstring value context");
            }
        }
        return selfReference;
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        this.setIsErroneous(true);
        return this;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        ReferenceChain tempReferencChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue temp = this.getValueRefdLast(timestamp, tempReferencChain);
        tempReferencChain.release();
        if (!temp.getIsErroneous(timestamp) && this != temp && referenceChain.add(this)) {
            temp.checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment assignment) {
        return false;
    }

    @Override
    public boolean checkExpressionSelfReferenceValue(CompilationTimeStamp timestamp, Assignment lhs) {
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        }
        if (governor == null) {
            return false;
        }
        return governor.checkThisValue(timestamp, this, lhs, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, true, false, false, false));
    }

    @Override
    public abstract String createStringRepresentation();

    @Override
    public abstract IType.Type_type getExpressionReturntype(CompilationTimeStamp var1, Expected_Value_type var2);

    @Override
    public final IValue getValueRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        return this.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, referenceChain);
    }

    @Override
    public IValue getValueRefdLast(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this;
        }
        this.setIsErroneous(false);
        this.lastTimeChecked = timestamp;
        return this;
    }

    @Override
    public IValue setLoweridToReference(CompilationTimeStamp timestamp) {
        return this;
    }

    @Override
    public void checkExpressionOmitComparison(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        this.getLocation().reportSemanticError("Only a referenced value can be compared with `omit'");
        this.setIsErroneous(true);
    }

    @Override
    public abstract boolean checkEquality(CompilationTimeStamp var1, IValue var2);

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public boolean evaluateIsbound(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        return true;
    }

    @Override
    public boolean evaluateIspresent(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        return true;
    }

    @Override
    public abstract void updateSyntax(TTCN3ReparseUpdater var1, boolean var2) throws ReParseException;

    @Override
    public final Definition getDefiningAssignment() {
        INamedNode parent;
        for (parent = this.getNameParent(); parent != null && !(parent instanceof Definition); parent = parent.getNameParent()) {
        }
        return (Definition)parent;
    }

    @Override
    public void setGenNameRecursive(String parameterGenName) {
        if (parameterGenName.endsWith("().get()")) {
            this.setGenName(parameterGenName.substring(0, parameterGenName.length() - 6));
        } else if (parameterGenName.endsWith("().constGet()")) {
            this.setGenName(parameterGenName.substring(0, parameterGenName.length() - 11));
        } else {
            this.setGenName(parameterGenName);
        }
    }

    @Override
    public boolean needsTemporaryReference() {
        return false;
    }

    @Override
    public boolean needsShortCircuit() {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return false;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        StringBuilder source = new StringBuilder();
        ErrorReporter.INTERNAL_ERROR((String)(this.getClass().getSimpleName() + ".generateSingleExpression() is not implemented!"));
        source.append("\t//TODO: ");
        source.append(this.getClass().getSimpleName());
        source.append(".generateSingleExpression() is not implemented!\n");
        return source;
    }

    @Override
    public boolean returnsNative() {
        return false;
    }

    @Override
    public abstract StringBuilder generateCodeInit(JavaGenData var1, StringBuilder var2, String var3);

    @Override
    public StringBuilder generateCodeInitMandatory(JavaGenData aData, StringBuilder source, String name) {
        return this.generateCodeInit(aData, source, name);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, boolean forceObject) {
        if (this.canGenerateSingleExpression()) {
            if (this.returnsNative() && forceObject) {
                IType gov = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
                expression.expression.append(MessageFormat.format("new {0}(", gov.getGenNameValue(aData, new StringBuilder())));
                expression.expression.append((CharSequence)this.generateSingleExpression(aData));
                expression.expression.append(")");
            } else {
                expression.expression.append((CharSequence)this.generateSingleExpression(aData));
            }
            return;
        }
        ErrorReporter.INTERNAL_ERROR((String)(this.getClass().getSimpleName() + ".generateCodeExpression() is not implemented!"));
    }

    @Override
    public void generateCodeExpressionMandatory(JavaGenData aData, ExpressionStruct expression, boolean forceObject) {
        this.generateCodeExpression(aData, expression, forceObject);
    }

    @Override
    public StringBuilder generateCodeTmp(JavaGenData aData, StringBuilder source, String prefix, AtomicInteger blockCount) {
        StringBuilder s2 = new StringBuilder();
        StringBuilder s1 = this.generateCodeTmp(aData, new StringBuilder(), s2);
        if (s2.length() > 0) {
            if (blockCount.get() == 0) {
                source.append("{\n");
                blockCount.incrementAndGet();
            }
            source.append((CharSequence)s2);
        }
        source.append(prefix);
        source.append((CharSequence)s1);
        return source;
    }

    @Override
    public StringBuilder generateCodeTmp(JavaGenData aData, StringBuilder source, StringBuilder init) {
        ExpressionStruct expression = new ExpressionStruct();
        this.generateCodeExpressionMandatory(aData, expression, false);
        if (expression.preamble.length() > 0 || expression.postamble.length() > 0) {
            String tempId = aData.getTemporaryVariableName();
            IType lastType = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            String typeName = IType.Type_type.TYPE_BOOL.equals((Object)lastType.getTypetype()) ? "boolean" : this.myGovernor.getGenNameValue(aData, init);
            init.append(MessageFormat.format("{0} {1};\n", typeName, tempId));
            init.append("{\n");
            if (expression.preamble.length() > 0) {
                init.append((CharSequence)expression.preamble);
            }
            if (IType.Type_type.TYPE_BOOL.equals((Object)lastType.getTypetype()) && !this.returnsNative()) {
                init.append(MessageFormat.format("{0} = TitanBoolean.get_native({1});\n", tempId, expression.expression));
            } else {
                init.append(MessageFormat.format("{0} = {1};\n", tempId, expression.expression));
            }
            if (expression.postamble.length() > 0) {
                init.append((CharSequence)expression.postamble);
            }
            init.append("}\n");
            source.append(tempId);
        } else {
            source.append((CharSequence)expression.expression);
        }
        return source;
    }

    @Override
    public void generateCodeLog(JavaGenData aData, ExpressionStruct expression) {
        this.generateCodeExpression(aData, expression, true);
        expression.expression.append(".log()");
    }

    public static void generateCodeExpressionOptionalFieldReference(JavaGenData aData, ExpressionStruct expression, Reference reference) {
        Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        switch (assignment.getAssignmentType()) {
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                if (!assignment.getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(reference.getSubreferences())) break;
                expression.expression.append(".constGet()");
                break;
            }
        }
    }
}

