/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.designer.actions.ExternalTitanAction;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANInstallationValidator;
import org.eclipse.titan.designer.core.TITANJob;
import org.eclipse.titan.designer.license.LicenseValidator;

public final class ConvertXSD2TTCN
extends ExternalTitanAction {
    private static final String JOB_TITLE = "Converting XSD files to TTCN-3";
    private File outputFolder;

    private void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void run(IAction action) {
        this.doConversion();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doConversion();
        return null;
    }

    private void doConversion() {
        if (!TITANInstallationValidator.check(true)) {
            return;
        }
        if (!LicenseValidator.check()) {
            return;
        }
        this.processSelection();
        if (this.files == null || this.files.isEmpty()) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Converting XSD files to TTCN-3 ...failed", (String)"No valid files were selected.");
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DirectoryDialog dialog = new DirectoryDialog(new Shell(Display.getDefault()), 57348);
                dialog.setFilterPath(ConvertXSD2TTCN.this.project.getLocation().toOSString());
                String outFolder = dialog.open();
                if (outFolder != null && (outFolder = outFolder.trim()).length() > 0) {
                    ConvertXSD2TTCN.this.setOutputFolder(new File(outFolder));
                }
            }
        });
        if (this.outputFolder == null) {
            return;
        }
        TITANJob titanJob = new TITANJob(JOB_TITLE, this.files, this.outputFolder, this.project);
        titanJob.setPriority(50);
        titanJob.setUser(true);
        titanJob.setRule((ISchedulingRule)this.project);
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        ArrayList<String> command = new ArrayList<String>();
        IPreferencesService prefs = Platform.getPreferencesService();
        String pathOfTITAN = prefs.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.TTCN3_INSTALL_DIR", "", null);
        StringBuilder output = new StringBuilder();
        command.add(PathConverter.convert((String)new Path(pathOfTITAN + File.separatorChar + "bin" + File.separatorChar + "xsd2ttcn").toOSString(), (boolean)reportDebugInformation, (StringBuilder)output));
        TITANDebugConsole.println(output);
        for (String filePath : this.files.keySet()) {
            command.add('\'' + filePath + '\'');
        }
        titanJob.addCommand(command, JOB_TITLE);
        titanJob.removeCompilerMarkers();
        String markersAfterCompiler = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.ontheflyMarkersAfterCompiler", "Are removed", null);
        if ("Are removed".equals(markersAfterCompiler)) {
            titanJob.removeOnTheFlyMarkers();
        }
        titanJob.schedule();
    }
}

