/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.titan.designer.actions.ExternalTitanAction;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.core.TITANJob;

public final class MakeArchive
extends ExternalTitanAction {
    private static final String JOB_TITLE = "Make archive";
    private static final String COMMAND = "make archive";
    private static final String BIN_SUBPATH = File.separatorChar + "bin" + File.separatorChar;

    public void run(IAction action) {
        this.doMakeArchive();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doMakeArchive();
        return null;
    }

    private void doMakeArchive() {
        this.processSelection();
        if (this.singleSelectedProject == null) {
            TITANConsole.println("Make archive works only for single selected project");
            return;
        }
        File binDir = new File(this.singleSelectedProject.getLocation().toFile(), BIN_SUBPATH);
        TITANJob titanJob = new TITANJob(JOB_TITLE, new HashMap<String, IFile>(), binDir, this.project);
        titanJob.setPriority(50);
        titanJob.setUser(true);
        titanJob.setRule((ISchedulingRule)this.project);
        ArrayList<String> command = new ArrayList<String>();
        command.add(COMMAND);
        titanJob.addCommand(command, JOB_TITLE);
        titanJob.schedule();
    }
}

