/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class Stylers {
    public static final Color PublicColor = new Color((Device)Display.getCurrent(), 59, 179, 0);
    public static final Color ProtectedColor = new Color((Device)Display.getCurrent(), 255, 140, 25);
    public static final Color PrivateColor = new Color((Device)Display.getCurrent(), 227, 38, 54);

    private Stylers() {
    }

    public static class TextAttributeStyler
    extends StyledString.Styler {
        private final TextAttribute attribute;
        private static Font f;

        public TextAttributeStyler(TextAttribute attribute) {
            this.attribute = attribute;
            if (f == null) {
                FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
                fontData.setStyle(attribute.getStyle());
                f = new Font((Device)Display.getDefault(), fontData);
            }
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.background = this.attribute.getBackground();
            textStyle.foreground = this.attribute.getForeground();
            textStyle.font = f;
            textStyle.strikeout = (this.attribute.getStyle() & 0x20000000) > 0;
        }
    }

    public static class ColoredStyler
    extends StyledString.Styler {
        private final Color color;
        private int style;
        private static Font f;

        public ColoredStyler(Color color) {
            this.color = color;
            if (f == null) {
                FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
                fontData.setStyle(this.style);
                f = new Font((Device)Display.getDefault(), fontData);
            }
        }

        public void setStyle(int style) {
            this.style = style;
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = this.color;
            textStyle.font = f;
        }
    }

    public static class StrikethroughStyler
    extends StyledString.Styler {
        private static Font f;

        public StrikethroughStyler() {
            if (f == null) {
                FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
                f = new Font((Device)Display.getDefault(), fontData);
            }
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = f;
            textStyle.strikeout = true;
        }
    }

    public static class ItalicStyler
    extends StyledString.Styler {
        private static Font f;

        public ItalicStyler() {
            if (f == null) {
                FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
                fontData.setStyle(2);
                f = new Font((Device)Display.getDefault(), fontData);
            }
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = f;
        }
    }

    public static class BlackItalicStyler
    extends StyledString.Styler {
        private static Font f;

        public BlackItalicStyler() {
            if (f == null) {
                FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
                fontData.setStyle(2);
                f = new Font((Device)Display.getDefault(), fontData);
            }
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = new Color((Device)Display.getCurrent(), 0, 0, 0);
            textStyle.font = f;
        }
    }

    public static class BoldStyler
    extends StyledString.Styler {
        private static Font f;

        public BoldStyler() {
            if (f == null) {
                FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
                fontData.setStyle(1);
                f = new Font((Device)Display.getDefault(), fontData);
            }
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = f;
        }
    }

    public static class BlueBoldStyler
    extends StyledString.Styler {
        private static Font f;

        public BlueBoldStyler() {
            if (f == null) {
                FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
                fontData.setStyle(1);
                f = new Font((Device)Display.getDefault(), fontData);
            }
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = new Color((Device)Display.getCurrent(), 16, 66, 255);
            textStyle.font = f;
        }
    }
}

