/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.editors.BaseTextHover;
import org.eclipse.titan.designer.editors.IReferenceParser;
import org.eclipse.titan.designer.editors.asn1editor.ASN1Editor;
import org.eclipse.titan.designer.editors.asn1editor.ASN1ReferenceParser;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverInfoControl;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;

public final class TextHover
extends BaseTextHover
implements ITextHoverExtension,
ITextHoverExtension2 {
    private final ISourceViewer sourceViewer;
    private final IEditorPart editor;

    public TextHover(ISourceViewer sourceViewer, ASN1Editor editor) {
        this.sourceViewer = sourceViewer;
        this.editor = editor;
    }

    @Override
    protected ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    @Override
    protected IEditorPart getTargetEditor() {
        return this.editor;
    }

    @Override
    protected IReferenceParser getReferenceParser() {
        return new ASN1ReferenceParser();
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        boolean enableCodeHoverPopups = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableHoverWindowPopups", true, null);
        if (!enableCodeHoverPopups) {
            return "";
        }
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module tempModule = projectSourceParser.containedModule(file);
        if (tempModule == null) {
            return "";
        }
        Ttcn3HoverContent info = null;
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(hoverRegion.getOffset());
        tempModule.accept(visitor);
        Declaration declaration = visitor.getReferencedDeclaration();
        if (declaration == null) {
            return "";
        }
        ICommentable commentable = declaration.getCommentable();
        if (commentable == null) {
            return "";
        }
        info = commentable.getHoverContent(this.editor);
        if (info == null) {
            return "";
        }
        return info;
    }

    @Override
    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new Ttcn3HoverInfoControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }
}

