/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchy;
import org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchyNode;
import org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchyView;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class CallHierarchyAction
extends AbstractHandler
implements IEditorActionDelegate {
    private ISelection selection = TextSelection.emptySelection();
    private IEditorPart targetEditor;
    private static final String SHOW_VIEW_ERROR = "The Call Hierarchy view cannot be displayed.";
    private static final String REFERENCE_SEARCH_FAILED = "The Call Hierarchy search failed.";
    private static final String STATUS_LINE_MESSAGE_ICON = "titan.gif";
    private static final String STATUS_LINE_ERROR_ICON = "compiler_error_fresh.gif";
    private static final int STATUS_LINE_LEVEL_MESSAGE = 0;
    private static final int STATUS_LINE_LEVEL_ERROR = 1;
    private static final int STATUS_LINE_CLEAR = -1;

    public void run(IAction action) {
        this.processing(this.selection);
    }

    public void selectionChanged(IAction action, ISelection currentSelection) {
        this.selection = currentSelection;
    }

    public void setActiveEditor(IAction action, IEditorPart activeEditor) {
        this.targetEditor = activeEditor;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.processing(this.selection);
        return null;
    }

    private void processing(ISelection currentSelection) {
        this.clearStatusLineMessage();
        CallHierarchyView callHierarchyView = CallHierarchyView.showView();
        if (callHierarchyView == null) {
            this.showStatusLineMessage(SHOW_VIEW_ERROR, 1);
            return;
        }
        CallHierarchy callHierarchy = callHierarchyView.getCallHierarchy();
        CallHierarchyNode selectedNode = callHierarchy.functionCallFinder(currentSelection);
        if (selectedNode == null) {
            this.showStatusLineMessage(REFERENCE_SEARCH_FAILED, 1);
            return;
        }
        callHierarchy.addToSearchLog(selectedNode);
        CallHierarchyNode root = new CallHierarchyNode();
        root.addChild(selectedNode);
        callHierarchyView.setAction(this);
        callHierarchyView.setInput(root);
    }

    public void processing(CallHierarchyNode searchabledNode) {
        searchabledNode.clearNode();
        this.clearStatusLineMessage();
        CallHierarchyView callHierarchyView = CallHierarchyView.showView();
        if (callHierarchyView == null) {
            this.showStatusLineMessage(SHOW_VIEW_ERROR, 1);
            return;
        }
        CallHierarchy callHierarchy = callHierarchyView.getCallHierarchy();
        CallHierarchyNode selectedNode = callHierarchy.functionCallFinder(searchabledNode);
        if (selectedNode == null) {
            this.showStatusLineMessage(REFERENCE_SEARCH_FAILED, 1);
            return;
        }
        callHierarchy.setCurrentNode(selectedNode);
        callHierarchy.addToSearchLog(selectedNode);
        CallHierarchyNode root = new CallHierarchyNode();
        root.addChild(selectedNode);
        callHierarchyView.setAction(this);
        callHierarchyView.setInput(root);
    }

    private void showStatusLineMessage(String message, int level) {
        IStatusLineManager statusLineManager;
        if (this.targetEditor == null) {
            this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if ((statusLineManager = this.targetEditor.getEditorSite().getActionBars().getStatusLineManager()) == null) {
            return;
        }
        statusLineManager.setMessage(null);
        statusLineManager.setErrorMessage(null);
        if (level == 0) {
            statusLineManager.setMessage(ImageCache.getImage(STATUS_LINE_MESSAGE_ICON), message);
        }
        if (level == 1) {
            statusLineManager.setErrorMessage(ImageCache.getImage(STATUS_LINE_ERROR_ICON), message);
        }
    }

    private void clearStatusLineMessage() {
        this.showStatusLineMessage("", -1);
    }
}

