/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class ClassExtendsContext
extends ProposalContext {
    public ClassExtendsContext(ProposalContextInfo proposalContextInfo) {
        super(proposalContextInfo);
        this.doFallback = false;
    }

    @Override
    public void getProposals(ProposalCollector propCollector) {
        Matcher matcher = this.proposalContextInfo.matcher;
        String className = matcher.group(3);
        String[] existingExtends = matcher.group(4) != null ? matcher.group(4).split(",") : null;
        ArrayList existingExtendsList = existingExtends != null ? Arrays.asList(existingExtends) : new ArrayList();
        CompilationTimeStamp timestamp = this.proposalContextInfo.module.getLastCompilationTimeStamp();
        ArrayList<String> excludeNames = new ArrayList<String>();
        excludeNames.add(className);
        boolean nonTraitListed = false;
        ArrayList<String> nonTraitClassNames = new ArrayList<String>();
        List<Assignment> classes = this.getAvailableAssignmentsByType(IType.Type_type.TYPE_CLASS);
        for (Assignment cItem : classes) {
            IType type = cItem.getType(timestamp);
            if (type instanceof Class_Type) {
                Class_Type classType = (Class_Type)type;
                String cName = cItem.getGenName();
                if (existingExtendsList.contains(cName)) {
                    excludeNames.add(cName);
                    if (!classType.isTrait()) {
                        nonTraitListed = true;
                    }
                } else if (!classType.isTrait()) {
                    nonTraitClassNames.add(cName);
                }
                if (classType.isFinal()) {
                    excludeNames.add(cName);
                }
            }
            if (!nonTraitListed) continue;
            excludeNames.addAll(nonTraitClassNames);
        }
        String prefix = this.getPrefix();
        this.addItemsByType(null, IType.Type_type.TYPE_CLASS, propCollector, prefix, excludeNames);
    }
}

