/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.ResourceUtils;
import org.eclipse.titan.designer.properties.data.ListConverter;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.MyListControl;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;

public final class PlatformSpecificLibrariesOptionsPage
implements IOptionsPage {
    private Composite mainComposite;
    private MyListControl libraries;
    private final String platform;

    public PlatformSpecificLibrariesOptionsPage(String platform) {
        this.platform = platform;
    }

    @Override
    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
            this.libraries.dispose();
        }
    }

    @Override
    public Composite createContents(Composite parent) {
        if (this.mainComposite != null) {
            return this.mainComposite;
        }
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.libraries = new MyListControl(this.mainComposite, "Additional libraries (-l)", "library");
        return this.mainComposite;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mainComposite == null) {
            return;
        }
        this.libraries.setEnabled(enabled);
    }

    @Override
    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = ResourceUtils.getPersistentProperty((IResource)project, (String)"org.eclipse.titan.designer.Properties.Project", (String)(this.platform + "SpecificLibrariesProperty"));
        if (temp != null) {
            tempStorage.setValue(this.platform + "SpecificLibrariesProperty", temp);
        }
    }

    @Override
    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        String actualValue = ResourceUtils.getPersistentProperty((IResource)project, (String)"org.eclipse.titan.designer.Properties.Project", (String)(this.platform + "SpecificLibrariesProperty"));
        String copyValue = tempStorage.getString(this.platform + "SpecificLibrariesProperty");
        return actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
    }

    @Override
    public void performDefaults() {
        if (this.mainComposite == null) {
            return;
        }
        this.libraries.setEnabled(true);
        this.libraries.setValues(new String[0]);
    }

    @Override
    public boolean checkProperties(ProjectBuildPropertyPage page) {
        return true;
    }

    @Override
    public void loadProperties(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", this.platform + "SpecificLibrariesProperty"));
            this.libraries.setValues(ListConverter.convertToList(temp));
        }
        catch (CoreException e) {
            this.libraries.setValues(new String[0]);
        }
    }

    @Override
    public boolean saveProperties(IProject project) {
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", this.platform + "SpecificLibrariesProperty");
            String newValue = ListConverter.convertFromList(this.libraries.getValues());
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }
}

