/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.StatisticalView;
import org.eclipse.titan.log.viewer.views.text.table.TextTableViewHelper;
import org.eclipse.ui.actions.SelectionProviderAction;

public class OpenTextTableStatisticalViewMenuAction
extends SelectionProviderAction {
    private static final String NAME = Messages.getString("OpenTextTableMenuAction.0");
    private IStructuredSelection selection;
    private StatisticalView statisticalView;

    public OpenTextTableStatisticalViewMenuAction(StatisticalView statisticalView) {
        super((ISelectionProvider)statisticalView, NAME);
        this.statisticalView = statisticalView;
    }

    public void run() {
        Object element = this.selection.getFirstElement();
        if (!(element instanceof TestCase)) {
            return;
        }
        TestCase tc = (TestCase)element;
        LogFileMetaData logFileMetaData = this.statisticalView.getLogFileMetaData();
        TextTableViewHelper.open(logFileMetaData.getProjectName(), logFileMetaData.getProjectRelativePath(), tc.getStartRecordNumber());
    }

    public void selectionChanged(IStructuredSelection selection) {
        boolean enabled = true;
        this.selection = selection;
        if (this.selection.isEmpty() || !(this.selection.getFirstElement() instanceof TestCase)) {
            enabled = false;
        }
        this.setEnabled(enabled);
        super.selectionChanged(selection);
    }
}

