/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.parsers.data;

import java.io.Serializable;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;

public class TestCase
implements Serializable {
    private static final long serialVersionUID = -4142445231973786330L;
    private int testCaseNumber;
    private String testCaseName;
    private long filePointer;
    private int verdict;
    private int startRecordNumber;
    private int endRecordNumber;
    private final URI logFileURI;
    private transient IFile logFile;

    public TestCase(IFile logFile, int testCaseNumber, String testCaseName, long filePointer, int verdict, int startRecordNumber, int endRecordNumber) {
        this.logFile = logFile;
        this.logFileURI = logFile.getLocationURI();
        this.testCaseNumber = testCaseNumber;
        this.testCaseName = testCaseName;
        this.filePointer = filePointer;
        this.verdict = verdict;
        this.startRecordNumber = startRecordNumber;
        this.endRecordNumber = endRecordNumber;
    }

    public TestCase(IFile logFile) {
        this.logFile = logFile;
        this.logFileURI = logFile.getLocationURI();
    }

    public IFile getLogFile() {
        if (this.logFile != null) {
            return this.logFile;
        }
        IFile[] logFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(this.logFileURI);
        if (logFiles.length > 0) {
            this.logFile = logFiles[0];
        }
        return this.logFile;
    }

    public void setTestCaseNumber(int testCaseNumber) {
        this.testCaseNumber = testCaseNumber;
    }

    public int getTestCaseNumber() {
        return this.testCaseNumber;
    }

    public void setTestCaseName(String testCaseName) {
        this.testCaseName = testCaseName;
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public void setFilePointer(long filePointer) {
        this.filePointer = filePointer;
    }

    public long getFilePointer() {
        return this.filePointer;
    }

    public int getNumberOfRecords() {
        return this.endRecordNumber - this.startRecordNumber + 1;
    }

    public void setVerdict(int verdict) {
        this.verdict = verdict;
    }

    public int getVerdict() {
        return this.verdict;
    }

    public int getStartRecordNumber() {
        return this.startRecordNumber;
    }

    public void setStartRecordNumber(int startRecordNumber) {
        this.startRecordNumber = startRecordNumber;
    }

    public int getEndRecordNumber() {
        return this.endRecordNumber;
    }

    public void setEndRecordNumber(int stopRecordNumber) {
        this.endRecordNumber = stopRecordNumber;
    }

    public boolean isControlPart() {
        int indexOfSpace = "controlpart".length();
        return this.testCaseName != null && this.testCaseName.length() > indexOfSpace && this.testCaseName.charAt(indexOfSpace) == ' ';
    }
}

