/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.parser;

import com.google.common.collect.Iterators;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.parser.PListPath;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class PListContentHandler<T>
extends DefaultHandler {
    private static final System.Logger LOGGER = System.getLogger(PListContentHandler.class.getName());
    private @Nullable PListObject currObject;
    private @Nullable T result;
    private final PropertySettable.Factory<PListPath> objectFactory;
    private final PListPathImpl path = new PListPathImpl();
    private final StringBuilder text = new StringBuilder();

    PListContentHandler(PropertySettable.Factory<PListPath> objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public void startElement(@Nullable String uri, @Nullable String localName, @Nullable String qName, @Nullable Attributes attributes) throws SAXException {
        assert (localName != null);
        ++this.path.depth;
        switch (localName) {
            case "dict": {
                if (this.result == null) {
                    this.result = this.objectFactory.create(this.path);
                    this.currObject = new PListObject(this.currObject, this.result);
                    break;
                }
                this.currObject = new PListObject(this.currObject, this.objectFactory.create(this.path));
                break;
            }
            case "array": {
                if (this.result == null) {
                    this.result = new ArrayList();
                    this.currObject = new PListObject(this.currObject, this.result);
                    break;
                }
                this.currObject = new PListObject(this.currObject, new ArrayList());
            }
        }
        this.text.setLength(0);
    }

    @Override
    public void endElement(@Nullable String uri, @Nullable String localName, @Nullable String qName) throws SAXException {
        assert (localName != null);
        PListObject currObject = this.currObject;
        if (currObject == null) {
            throw new SAXException("Root <plist><dict> or <plist><array> element not found!");
        }
        this.path.trim();
        --this.path.depth;
        switch (localName) {
            case "key": {
                if (!(currObject.values instanceof PropertySettable)) {
                    LOGGER.log(System.Logger.Level.WARNING, "<key> tag can only be used inside an open <dict> element");
                    break;
                }
                this.path.add(this.text.toString());
                break;
            }
            case "dict": 
            case "array": {
                PListObject parent = currObject.parent;
                if (parent == null) break;
                parent.addValue(currObject.values);
                this.currObject = parent;
                break;
            }
            case "string": 
            case "data": {
                currObject.addValue(this.text.toString());
                break;
            }
            case "date": {
                try {
                    currObject.addValue(ZonedDateTime.parse(this.text.toString()));
                }
                catch (DateTimeParseException ex) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to parse date '" + this.text + "'. " + ex);
                }
                break;
            }
            case "integer": {
                try {
                    currObject.addValue(Integer.parseInt(this.text.toString()));
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to parse integer '" + this.text + "'. " + ex);
                }
                break;
            }
            case "real": {
                try {
                    currObject.addValue(Float.valueOf(Float.parseFloat(this.text.toString())));
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to parse real as float '" + this.text + "'. " + ex);
                }
                break;
            }
            case "true": {
                currObject.addValue(Boolean.TRUE);
                break;
            }
            case "false": {
                currObject.addValue(Boolean.FALSE);
                break;
            }
            default: {
                LOGGER.log(System.Logger.Level.WARNING, "Invalid tag name: " + localName);
            }
            case "plist": 
        }
    }

    @Override
    public void characters(char @Nullable [] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    void characters(String chars) {
        this.text.append(chars);
    }

    public T getResult() {
        assert (this.result != null);
        return this.result;
    }

    private final class PListObject {
        final @Nullable PListObject parent;
        final Object values;

        PListObject(PListObject parent, Object values) {
            this.parent = parent;
            this.values = values;
        }

        /*
         * WARNING - void declaration
         */
        void addValue(Object value) {
            Object object = this.values;
            if (object instanceof PropertySettable var2_3) {
                void propertySettable;
                propertySettable.setProperty(PListContentHandler.this.path.last(), value);
            } else {
                Object object2 = this.values;
                if (object2 instanceof List var5_5) {
                    void list;
                    list.add(value);
                }
            }
        }
    }

    private static final class PListPathImpl
    implements PListPath {
        final LinkedList<String> keys = new LinkedList();
        final List<Integer> keysDepths = new ArrayList<Integer>();
        int depth = 0;

        private PListPathImpl() {
        }

        void add(String key) {
            this.trim();
            this.keysDepths.add(this.depth);
            this.keys.add(key);
        }

        void trim() {
            int i = this.keysDepths.size() - 1;
            while (i >= 0) {
                if (this.keysDepths.get(i) >= this.depth) {
                    this.keysDepths.remove(i);
                    this.keys.remove(i);
                }
                --i;
            }
        }

        @Override
        public String get(int index) {
            return this.keys.get(index);
        }

        @Override
        public String first() {
            return this.keys.getFirst();
        }

        @Override
        public String last() {
            return this.keys.getLast();
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.unmodifiableIterator(this.keys.iterator());
        }

        @Override
        public int size() {
            return this.keys.size();
        }

        public String toString() {
            return String.join((CharSequence)"/", (CharSequence[])this.keys.toArray(String[]::new));
        }
    }
}

