/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.symbols;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.callstack.FunctionNameMapper;
import org.eclipse.tracecompass.internal.tmf.core.callstack.MappingFile;
import org.eclipse.tracecompass.internal.tmf.core.callstack.SizedMappingFile;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;

public interface IMappingFile {
    public static final /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tracecompass$internal$tmf$core$callstack$FunctionNameMapper$MappingType;

    public static @Nullable IMappingFile create(String fullPath, boolean isBinaryFile) {
        Path path = Paths.get(fullPath, new String[0]);
        String filename = path.getFileName().toString();
        Pattern pattern = Pattern.compile("(.+)-([0-9]+)\\.(.+)");
        Matcher matcher = pattern.matcher(filename);
        int pid = -1;
        if (matcher.find()) {
            try {
                pid = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IMappingFile.create(fullPath, isBinaryFile, pid);
    }

    public static @Nullable IMappingFile create(String fullPath, boolean isBinaryFile, int pid) {
        Path path = Paths.get(fullPath, new String[0]);
        Map<Long, TmfResolvedSymbol> results = null;
        if (isBinaryFile) {
            results = FunctionNameMapper.mapFromBinaryFile(path.toFile());
            return new MappingFile(fullPath, isBinaryFile, results, pid);
        }
        switch (FunctionNameMapper.guessMappingType(path.toFile())) {
            case MAP_WITH_SIZE: {
                results = FunctionNameMapper.mapFromSizedTextFile(path.toFile());
                return results == null ? null : new SizedMappingFile(fullPath, isBinaryFile, results, pid);
            }
            case NM: {
                results = FunctionNameMapper.mapFromNmTextFile(path.toFile());
                return results == null ? null : new MappingFile(fullPath, isBinaryFile, results, pid);
            }
        }
        return null;
    }

    public String getFullPath();

    public boolean isBinaryFile();

    public @Nullable TmfResolvedSymbol getSymbolEntry(long var1);

    public int getPid();
}

