/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages;

import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.AbstractRos2StateSystemAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesStateProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class Ros2MessagesAnalysis
extends AbstractRos2StateSystemAnalysis {
    private static final @NonNull String ID_SUFFIX = ".messages";

    public Ros2MessagesAnalysis() {
        super(Ros2MessagesAnalysis.getFullAnalysisId());
    }

    public static @NonNull String getFullAnalysisId() {
        return AbstractRos2StateSystemAnalysis.getAnalysisIdFromSuffix(ID_SUFFIX);
    }

    protected @NonNull ITmfStateProvider createStateProvider() {
        @NonNull ITmfTrace trace = Objects.requireNonNull(this.getTrace());
        Ros2ObjectsAnalysis objectsAnalysis = (Ros2ObjectsAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, Ros2ObjectsAnalysis.class, (String)Ros2ObjectsAnalysis.getFullAnalysisId());
        Objects.requireNonNull(objectsAnalysis);
        objectsAnalysis.schedule();
        objectsAnalysis.waitForCompletion();
        ITmfStateSystem ss = Ros2MessagesAnalysis.getStateSystem((ITmfTrace)trace, (String)Ros2ObjectsAnalysis.getFullAnalysisId());
        return new Ros2MessagesStateProvider(trace, Objects.requireNonNull(ss));
    }

    protected @NonNull Iterable<@NonNull IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptySet();
        }
        Ros2ObjectsAnalysis objectsAnalysis = (Ros2ObjectsAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, Ros2ObjectsAnalysis.class, (String)Ros2ObjectsAnalysis.getFullAnalysisId());
        if (objectsAnalysis == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(objectsAnalysis);
    }
}

