/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.inandout.core.analysis;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.incubator.internal.inandout.core.Activator;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.InAndOutAnalysisModule;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.config.ITmfDataProviderConfigurator;
import org.eclipse.tracecompass.tmf.core.config.TmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class InAndOutDataProviderFactory
implements IDataProviderFactory,
ITmfDataProviderConfigurator {
    public static final String ID = "org.eclipse.tracecompass.incubator.inandout.core.analysis.inAndOutdataProviderFactory";
    private static final ITmfConfigurationSourceType CONFIG_SOURCE_TYPE;
    private static final String NAME = "In And Out Analysis";
    private static final String DESCRIPTION = "Configure In And Out analysis using file description";
    private static final String CONFIGURATOR_NAME = "InAndOut Configurator";
    private static final String CONFIGURATOR_DESCRIPTION = "Configure custom InAndOut analysis";
    private static final String CUSTOM_IN_AND_OUT_ANALYSIS_NAME = "InAndOut Analysis ({0})";
    private static final String CUSTOM_IN_AND_OUT_ANALYSIS_DESCRIPTION = "Custom InAndOut analysis configured by \" {0}\"";
    private static final Table<String, ITmfTrace, ITmfConfiguration> fTmfConfigurationTable;
    private static final IDataProviderDescriptor DESCRIPTOR;

    static {
        fTmfConfigurationTable = HashBasedTable.create();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.tracecompass.incubator.inandout.core");
        Path defaultPath = new Path("schema/in-and-out-analysis.json");
        URL url = FileLocator.find((Bundle)bundle, (IPath)defaultPath, null);
        File schemaFile = null;
        try {
            schemaFile = new File(FileLocator.toFileURL((URL)url).toURI());
        }
        catch (IOException | URISyntaxException e) {
            Activator.getInstance().logError("Failed to read schema file: schema/in-and-out-analysis.json", (Throwable)e);
        }
        CONFIG_SOURCE_TYPE = new TmfConfigurationSourceType.Builder().setId("org.eclipse.tracecompass.incubator.internal.inandout.core.config").setDescription(DESCRIPTION).setName(NAME).setSchemaFile(schemaFile).build();
        DESCRIPTOR = new DataProviderDescriptor.Builder().setId(ID).setName(CONFIGURATOR_NAME).setDescription(CONFIGURATOR_DESCRIPTION).setProviderType(IDataProviderDescriptor.ProviderType.NONE).build();
    }

    public InAndOutDataProviderFactory() {
        TmfSignalManager.register((Object)this);
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        return null;
    }

    public Collection<IDataProviderDescriptor> getDescriptors(ITmfTrace trace) {
        ArrayList<IDataProviderDescriptor> list = new ArrayList<IDataProviderDescriptor>();
        list.add(DESCRIPTOR);
        for (ITmfConfiguration config : fTmfConfigurationTable.column((Object)trace).values()) {
            list.add(InAndOutDataProviderFactory.getDescriptorFromConfig(config));
        }
        return list;
    }

    public @NonNull List<@NonNull ITmfConfigurationSourceType> getConfigurationSourceTypes() {
        return List.of(CONFIG_SOURCE_TYPE);
    }

    public @NonNull IDataProviderDescriptor createDataProviderDescriptors(ITmfTrace trace, ITmfConfiguration configuration) throws TmfConfigurationException {
        if (configuration.getName().equals("---unknown---")) {
            throw new TmfConfigurationException("Missing configuration name of InAndOut analysis");
        }
        if (configuration.getSourceTypeId().equals("---unknown---")) {
            throw new TmfConfigurationException("Missing configuration type for InAndOut analysis");
        }
        Object description = configuration.getDescription();
        if (configuration.getDescription().equals("---unknown---")) {
            description = "InAndOut Analysis defined by configuration " + configuration.getName();
        }
        TmfConfiguration.Builder builder = new TmfConfiguration.Builder();
        builder.setId(configuration.getId()).setSourceTypeId(configuration.getSourceTypeId()).setName(configuration.getName()).setDescription((String)description).setParameters(configuration.getParameters()).build();
        ITmfConfiguration config = builder.build();
        this.applyConfiguration(trace, config, true);
        if (fTmfConfigurationTable.contains((Object)config.getId(), (Object)trace)) {
            throw new TmfConfigurationException("Configuration already existis with label: " + config.getName());
        }
        fTmfConfigurationTable.put((Object)config.getId(), (Object)trace, (Object)config);
        return InAndOutDataProviderFactory.getDescriptorFromConfig(config);
    }

    public void removeDataProviderDescriptor(ITmfTrace trace, IDataProviderDescriptor descriptor) throws TmfConfigurationException {
        ITmfConfiguration creationConfiguration = descriptor.getConfiguration();
        if (creationConfiguration == null) {
            throw new TmfConfigurationException("Data provider was not created by a configuration");
        }
        String configId = creationConfiguration.getId();
        ITmfConfiguration config = (ITmfConfiguration)fTmfConfigurationTable.get((Object)configId, (Object)trace);
        if (config == null) {
            return;
        }
        config = (ITmfConfiguration)fTmfConfigurationTable.remove((Object)configId, (Object)trace);
        this.removeConfiguration(trace, config);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (trace == null) {
            return;
        }
        try {
            if (trace instanceof TmfExperiment) {
                for (ITmfTrace tr : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                    List<ITmfConfiguration> configs = InAndOutAnalysisModule.readConfigurations(tr);
                    this.readAndApplyConfiguration(trace, configs);
                }
            } else {
                List<ITmfConfiguration> configs = InAndOutAnalysisModule.readConfigurations(trace);
                this.readAndApplyConfiguration(trace, configs);
            }
        }
        catch (TmfConfigurationException e) {
            Activator.getInstance().logError("Error applying configurations for trace " + trace.getName(), (Throwable)e);
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        fTmfConfigurationTable.column((Object)trace).clear();
    }

    private void readAndApplyConfiguration(ITmfTrace trace, List<ITmfConfiguration> configs) throws TmfConfigurationException {
        for (ITmfConfiguration config : configs) {
            if (fTmfConfigurationTable.contains((Object)config.getId(), (Object)trace)) continue;
            fTmfConfigurationTable.put((Object)config.getId(), (Object)trace, (Object)config);
            this.applyConfiguration(trace, config, false);
        }
    }

    private void applyConfiguration(ITmfTrace trace, ITmfConfiguration config, boolean writeConfig) throws TmfConfigurationException {
        if (trace instanceof TmfExperiment) {
            for (ITmfTrace tr : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                this.applyConfiguration(tr, config, writeConfig);
            }
            return;
        }
        InAndOutAnalysisModule.create(config, trace, writeConfig);
    }

    private void removeConfiguration(ITmfTrace trace, ITmfConfiguration config) throws TmfConfigurationException {
        if (trace instanceof TmfExperiment) {
            for (ITmfTrace tr : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                this.removeConfiguration(tr, config);
            }
            return;
        }
        InAndOutAnalysisModule.remove(config, trace);
    }

    private static IDataProviderDescriptor getDescriptorFromConfig(ITmfConfiguration config) {
        return new DataProviderDescriptor.Builder().setParentId(ID).setId("org.eclipse.tracecompass.incubator.inandout.analysis" + config.getId()).setName(NLS.bind((String)CUSTOM_IN_AND_OUT_ANALYSIS_NAME, (Object)config.getName())).setDescription(NLS.bind((String)CUSTOM_IN_AND_OUT_ANALYSIS_DESCRIPTION, (Object)config.getName())).setProviderType(IDataProviderDescriptor.ProviderType.NONE).setConfiguration(config).build();
    }
}

