/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows;

import java.util.Map;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsLocationGroup;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsNodeMap;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.IFlowsNode;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.Location;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

class FlowsLocation
extends Location
implements IFlowsNode {
    private int fInputQuark = -1;
    private int fOutputQuark = -1;
    private long fLatestEnteredTimestamp = 0L;
    private long fInputMessageSize = 0L;
    private long fOutputMessageSize = 0L;

    public FlowsLocation(ITmfEvent event) {
        super(event);
    }

    public void initializeQuarks(ITmfStateSystemBuilder ssb, FlowsNodeMap<Long, FlowsLocationGroup> locationGroupMap, Map<Integer, String> stringIdMap) {
        String locationName = this.getName(stringIdMap);
        long parentId = this.getLocationGroupId();
        int parentInputQuark = locationGroupMap.getNodeQuark(parentId, "In");
        int parentOutputQuark = locationGroupMap.getNodeQuark(parentId, "Out");
        this.fInputQuark = ssb.getQuarkRelativeAndAdd(parentInputQuark, new String[]{locationName});
        this.fOutputQuark = ssb.getQuarkRelativeAndAdd(parentOutputQuark, new String[]{locationName});
    }

    @Override
    public int getInputQuark() {
        return this.fInputQuark;
    }

    @Override
    public int getOutputQuark() {
        return this.fOutputQuark;
    }

    public long getLatestEnteredTimestamp() {
        return this.fLatestEnteredTimestamp;
    }

    public void setLatestEnteredTimestamp(long latestEnteredTimestamp) {
        this.fLatestEnteredTimestamp = latestEnteredTimestamp;
    }

    private void updateFlow(ITmfStateSystemBuilder ssb, Long messageLength, long endTimestamp, String direction) {
        int correctQuark = this.getQuark(direction);
        if (correctQuark == -1) {
            return;
        }
        long operationDuration = endTimestamp - this.fLatestEnteredTimestamp;
        double flow = (double)messageLength.longValue() / (double)operationDuration;
        StateSystemBuilderUtils.incrementAttributeDouble((ITmfStateSystemBuilder)ssb, (long)this.fLatestEnteredTimestamp, (int)correctQuark, (double)flow);
        StateSystemBuilderUtils.incrementAttributeDouble((ITmfStateSystemBuilder)ssb, (long)endTimestamp, (int)correctQuark, (double)(-flow));
    }

    public Long getOutputMessageSize() {
        return this.fOutputMessageSize;
    }

    public void setOutputMessageSize(Long messageLength) {
        this.fOutputMessageSize = messageLength;
    }

    public Long getInputMessageSize() {
        return this.fInputMessageSize;
    }

    public void setInputMessageSize(Long messageLength) {
        this.fInputMessageSize = messageLength;
    }

    public void processLeave(ITmfStateSystemBuilder ssb, long leaveTimestamp) {
        if (this.fInputMessageSize != 0L) {
            this.updateFlow(ssb, this.fInputMessageSize, leaveTimestamp, "In");
            this.fInputMessageSize = 0L;
        }
        if (this.fOutputMessageSize != 0L) {
            this.updateFlow(ssb, this.fOutputMessageSize, leaveTimestamp, "Out");
            this.fOutputMessageSize = 0L;
        }
    }
}

