/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.otf2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.Otf2FlowsAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2FlowsXYDataProvider
extends AbstractTreeCommonXDataProvider<Otf2FlowsAnalysis, TmfTreeDataModel>
implements IOutputStyleProvider {
    private static final String SUFFIX = ".xy.dataprovider";
    private static final String TITLE = "Flows XY dataprovider";
    private static final TmfXYAxisDescription Y_AXIS_DESCRIPTION = new TmfXYAxisDescription("Perceived data flows", "B/s", DataType.NUMBER);

    public Otf2FlowsXYDataProvider(ITmfTrace trace, Otf2FlowsAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    public String getId() {
        return ((Otf2FlowsAnalysis)this.getAnalysisModule()).getId() + SUFFIX;
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable Collection<IYModel> getYSeriesModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        ImmutableList.Builder ySeries = ImmutableList.builder();
        HashMap<Integer, double[]> quarkToValues = new HashMap<Integer, double[]>();
        List selectedItems = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (selectedItems == null) {
            return null;
        }
        List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        if (times == null) {
            return null;
        }
        Map idsToQuarks = this.getSelectedEntries(selectedItems);
        for (Integer n : idsToQuarks.values()) {
            quarkToValues.put(n, new double[times.size()]);
        }
        try {
            for (ITmfStateInterval iTmfStateInterval : ss.query2D(quarkToValues.keySet(), (Collection)times)) {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                double[] row = (double[])quarkToValues.get(iTmfStateInterval.getAttribute());
                Object value = iTmfStateInterval.getValue();
                if (row == null || !(value instanceof Number)) continue;
                Double dblValue = ((Number)value).doubleValue();
                int i = 0;
                while (i < times.size()) {
                    Long time = (Long)times.get(i);
                    if (iTmfStateInterval.getStartTime() <= time && iTmfStateInterval.getEndTime() >= time) {
                        double valueInBPerSecond;
                        row[i] = valueInBPerSecond = dblValue * 1.0E9;
                        int parentQuark = ss.getParentAttributeQuark(iTmfStateInterval.getAttribute());
                        while (parentQuark != -1) {
                            double[] parentRow = (double[])quarkToValues.get(parentQuark);
                            if (parentRow != null) {
                                int n = i;
                                parentRow[n] = parentRow[n] + valueInBPerSecond;
                            }
                            parentQuark = ss.getParentAttributeQuark(parentQuark);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            Activator.getInstance().logError(throwable.getMessage());
            return null;
        }
        for (Map.Entry entry : quarkToValues.entrySet()) {
            ySeries.add((Object)new YModel(this.getId((Integer)entry.getKey()), ss.getFullAttributePath(((Integer)entry.getKey()).intValue()), (double[])entry.getValue(), Y_AXIS_DESCRIPTION));
        }
        return ySeries.build();
    }

    protected boolean isCacheable() {
        return false;
    }

    protected TmfTreeModel<TmfTreeDataModel> getTree(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        long parentId = this.getId(-1);
        builder.add((Object)new TmfTreeDataModel(parentId, -1L, String.valueOf(this.getTrace().getName())));
        this.addChildren(ss, (ImmutableList.Builder<TmfTreeDataModel>)builder, -1, parentId);
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    protected void addChildren(ITmfStateSystem ss, ImmutableList.Builder<TmfTreeDataModel> builder, int quark, long parentId) {
        for (Integer child : ss.getSubAttributes(quark, false)) {
            long childId = this.getId(child);
            String name = ss.getFullAttributePath(child.intValue());
            builder.add((Object)new TimeGraphEntryModel(childId, parentId, name, ss.getStartTime(), ss.getCurrentEndTime(), true));
            this.addChildren(ss, builder, child, childId);
        }
    }

    protected String getTitle() {
        return TITLE;
    }

    public static String getFullDataProviderId() {
        return Otf2FlowsAnalysis.getFullAnalysisId() + SUFFIX;
    }
}

