/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraphVisitor;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;

public class TmfGraphStatistics
implements ITmfGraphVisitor {
    private final Map<IGraphWorker, Long> fWorkerStats = new HashMap<IGraphWorker, Long>();
    private Long fTotal = 0L;
    private @Nullable ITmfGraph fGraph;

    public void computeGraphStatistics(ITmfGraph graph, @Nullable IGraphWorker current) {
        if (current == null) {
            return;
        }
        this.clear();
        this.fGraph = graph;
        this.fGraph.scanLineTraverse(this.fGraph.getHead(current), (ITmfGraphVisitor)this);
    }

    @Override
    public void visitHead(ITmfVertex node) {
    }

    @Override
    public void visit(ITmfVertex node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(ITmfEdge edge, boolean horizontal) {
        ITmfGraph graph = this.fGraph;
        Map<IGraphWorker, Long> map = this.fWorkerStats;
        synchronized (map) {
            if (horizontal && graph != null) {
                IGraphWorker worker = graph.getParentOf(edge.getVertexFrom());
                if (worker == null) {
                    return;
                }
                Long duration = edge.getDuration();
                Long currentTotal = this.fWorkerStats.get(worker);
                if (currentTotal != null) {
                    duration = duration + currentTotal;
                }
                this.fWorkerStats.put(worker, duration);
                this.fTotal = this.fTotal + edge.getDuration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSum(@Nullable IGraphWorker worker) {
        Long sum = 0L;
        Map<IGraphWorker, Long> map = this.fWorkerStats;
        synchronized (map) {
            Long elapsed = this.fWorkerStats.get(worker);
            if (elapsed != null) {
                sum = sum + elapsed;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSum() {
        Map<IGraphWorker, Long> map = this.fWorkerStats;
        synchronized (map) {
            return this.fTotal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getPercent(@Nullable IGraphWorker worker) {
        Map<IGraphWorker, Long> map = this.fWorkerStats;
        synchronized (map) {
            if (this.getSum() == 0L) {
                return 0.0;
            }
            return (double)this.getSum(worker).longValue() / (double)this.getSum().longValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<IGraphWorker, Long> map = this.fWorkerStats;
        synchronized (map) {
            this.fTotal = 0L;
            this.fWorkerStats.clear();
        }
    }
}

