/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public final class SerialExecutor
extends Job {
    private final ConcurrentLinkedQueue<Runnable> queue;
    private final Object myFamily;

    public SerialExecutor(String jobName, Object family) {
        super(jobName);
        Assert.isNotNull((Object)family);
        this.myFamily = family;
        this.queue = new ConcurrentLinkedQueue();
        this.setSystem(true);
    }

    public boolean belongsTo(Object family) {
        return this.myFamily == family;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Runnable action = this.queue.poll();
        try {
            if (action != null) {
                action.run();
            }
        }
        finally {
            if (!this.queue.isEmpty()) {
                this.schedule();
            }
        }
        return Status.OK_STATUS;
    }

    public void schedule(Runnable action) {
        this.queue.offer(action);
        this.schedule();
    }
}

