/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.StringTokenizer;
import org.osgi.service.url.AbstractURLStreamHandlerService;

class DataURLStreamHandler
extends AbstractURLStreamHandlerService {
    static final String PROTOCOL = "data";
    private static final String CHARSET_TOKEN = "charset=";

    DataURLStreamHandler() {
    }

    public URLConnection openConnection(URL u) throws IOException {
        if (!PROTOCOL.equals(u.getProtocol())) {
            throw new MalformedURLException("Unsupported protocol");
        }
        return new DataURLConnection(u);
    }

    static final class DataURLConnection
    extends URLConnection {
        private ParseResult parsed;

        DataURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            this.parsed = DataURLConnection.parse(this.url.getPath());
        }

        static ParseResult parse(String ssp) throws IOException {
            byte[] bytes;
            int commaIndex = ssp.indexOf(44);
            if (commaIndex < 0) {
                throw new MalformedURLException("missing comma");
            }
            String paramSegment = ssp.substring(0, commaIndex);
            String dataSegment = ssp.substring(commaIndex + 1);
            String mediaType = null;
            boolean base64 = false;
            Charset charset = null;
            StringTokenizer tokenizer = new StringTokenizer(paramSegment, ";");
            boolean first = true;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (first) {
                    mediaType = token;
                } else if ("base64".equals(token)) {
                    base64 = true;
                } else if (token.startsWith(DataURLStreamHandler.CHARSET_TOKEN)) {
                    charset = Charset.forName(token.substring(DataURLStreamHandler.CHARSET_TOKEN.length()));
                }
                first = false;
            }
            if (base64) {
                bytes = Base64.getDecoder().decode(dataSegment);
            } else {
                String decoded = URLDecoder.decode(dataSegment, Objects.requireNonNullElse(charset, StandardCharsets.US_ASCII));
                bytes = decoded.getBytes(StandardCharsets.UTF_8);
            }
            ParseResult parsed = new ParseResult();
            parsed.data = bytes;
            if (mediaType != null && !mediaType.isEmpty()) {
                parsed.mediaType = mediaType;
            }
            parsed.charset = charset;
            return parsed;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.parsed == null) {
                this.connect();
            }
            return new ByteArrayInputStream(this.parsed.data);
        }

        @Override
        public String getContentType() {
            return this.parsed != null ? this.parsed.mediaType : null;
        }

        @Override
        public String getContentEncoding() {
            if (this.parsed != null && this.parsed.charset != null) {
                return this.parsed.charset.name();
            }
            return null;
        }
    }

    static class ParseResult {
        String mediaType = "text/plain";
        Charset charset;
        byte[] data;

        ParseResult() {
        }
    }
}

