/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.workingsets;

import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ui.internal.navigator.workingsets.WorkingSetsContentProvider;

public class WorkingSetSorter
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 == WorkingSetsContentProvider.OTHERS_WORKING_SET) {
            return 1;
        }
        if (e2 == WorkingSetsContentProvider.OTHERS_WORKING_SET) {
            return -1;
        }
        if (viewer instanceof StructuredViewer) {
            StructuredViewer sViewer = (StructuredViewer)viewer;
            ILabelProvider labelProvider = (ILabelProvider)sViewer.getLabelProvider();
            if (labelProvider instanceof DecoratingStyledCellLabelProvider) {
                DecoratingStyledCellLabelProvider dprov = (DecoratingStyledCellLabelProvider)labelProvider;
                DelegatingStyledCellLabelProvider.IStyledLabelProvider styledLabelProvider = dprov.getStyledStringProvider();
                String text1 = styledLabelProvider.getStyledText(e1).getString();
                String text2 = styledLabelProvider.getStyledText(e2).getString();
                if (text1 != null) {
                    return text1.compareTo(text2);
                }
                return -1;
            }
            if (labelProvider instanceof DecoratingLabelProvider) {
                DecoratingLabelProvider dprov = (DecoratingLabelProvider)labelProvider;
                labelProvider = dprov.getLabelProvider();
            }
            String text1 = labelProvider.getText(e1);
            String text2 = labelProvider.getText(e2);
            if (text1 != null) {
                return text1.compareTo(text2);
            }
        }
        return -1;
    }
}

