/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search.scope;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.core.search.scope.SearchScopeImpl;

public class ContentTypeSearchScope
extends SearchScopeImpl {
    private List validContentIds = new ArrayList();

    public ContentTypeSearchScope(SearchScope scope, String[] validContentTypes) {
        int i;
        if (validContentTypes != null) {
            i = 0;
            while (i < validContentTypes.length) {
                this.validContentIds.add(validContentTypes[i]);
                ++i;
            }
        }
        if (scope.enclosingFiles() != null) {
            i = 0;
            while (i < scope.enclosingFiles().length) {
                IFile file = scope.enclosingFiles()[i];
                this.acceptFile(file);
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean acceptFile(IFile file) {
        if (file == null) {
            return false;
        }
        try {
            String contentId;
            IContentTypeManager contentTypeManager;
            IContentType supportedContentType;
            IContentDescription description = file.getContentDescription();
            if (description == null) return false;
            IContentType contentType = description.getContentType();
            if (contentType == null) return false;
            Iterator iter = this.validContentIds.iterator();
            do {
                if (!iter.hasNext()) {
                    return false;
                }
                contentId = (String)iter.next();
            } while ((supportedContentType = (contentTypeManager = Platform.getContentTypeManager()).getContentType(contentId)) == null || !contentType.isKindOf(supportedContentType));
            this.files.add(file);
            this.projects.add(file.getProject());
            return true;
        }
        catch (CoreException coreException) {}
        return false;
    }
}

