/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;

public class Helper
extends WorkbenchContext {
    public static final String GET_PROJECT_FILES = "getAllFiles";
    public static final String GET_FILE = "getFile";
    public static final String VALIDATION_MARKER = "org.eclipse.wst.validation.problemmarker";
    public static final String VALIDATION_MARKER_OWNER = "owner";

    public Helper() {
        Class[] args = new Class[]{String.class};
        this.registerModel(GET_FILE, GET_FILE, args);
        this.registerModel(GET_PROJECT_FILES, "getFiles", args);
    }

    public IFile getFile(String filename) {
        IResource res = this.getProject().findMember(filename, true);
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public Collection getFiles(String validatorClassName) {
        IProject project = this.getProject();
        ArrayList files = new ArrayList();
        this.getFiles(files, (IContainer)project, validatorClassName);
        return files;
    }

    protected void getFiles(Collection files, IContainer resource, String validatorClassName) {
        try {
            IResource[] resourceArray = resource.members(false);
            int i = 0;
            while (i < resourceArray.length) {
                if (ValidatorManager.getManager().isApplicableTo(validatorClassName, resourceArray[i]) && resourceArray[i] instanceof IFile) {
                    files.add(resourceArray[i]);
                }
                if (resourceArray[i].getType() == 2) {
                    this.getFiles(files, (IContainer)resourceArray[i], validatorClassName);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public String getPortableName(IResource resource) {
        return resource.getProjectRelativePath().toString();
    }

    public String getTargetObjectName(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static void deleteMarkers(IResource resource, String markerType, final String attributeName, final Object attributeValue) throws CoreException {
        final IMarker[] v400Markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        final IMarker[] markers = resource.findMarkers(markerType, true, 2);
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor progressMonitor) throws CoreException {
                IMarker marker;
                int i = 0;
                while (i < v400Markers.length) {
                    marker = markers[i];
                    marker.delete();
                    ++i;
                }
                i = 0;
                while (i < markers.length) {
                    marker = markers[i];
                    Object value = marker.getAttribute(attributeName);
                    if (value != null && value.equals(attributeValue)) {
                        marker.delete();
                    }
                    ++i;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, null);
        }
        catch (Exception exception) {}
    }

    public static int getValidationFrameworkSeverity(int severity) {
        switch (severity) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 4;
            }
        }
        return 4;
    }
}

