/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.lami.core.tests.shared.analysis;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.lami.core.tests.Activator;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class LamiAnalysisStub
extends LamiAnalysis {
    private final @NonNull String fMetaDatafilename;
    private final @NonNull String fResultFilename;
    private @Nullable List<LamiResultTable> fResults = null;

    public LamiAnalysisStub(@NonNull String name, @NonNull String metaDatafilename, @NonNull String resultFilename) {
        super(name, false, o -> true, Collections.singletonList("StubExecutable"));
        this.fMetaDatafilename = metaDatafilename;
        this.fResultFilename = resultFilename;
    }

    public @NonNull String getName() {
        return this.fResultFilename;
    }

    protected @NonNull Multimap<@NonNull String, @NonNull LamiChartModel> getPredefinedCharts() {
        return ImmutableMultimap.of();
    }

    protected String getResultsFromCommand(List<String> command, IProgressMonitor monitor) throws CoreException {
        return LamiAnalysisStub.readLamiFile(this.fResultFilename);
    }

    protected @Nullable String getOutputFromCommand(List<String> command) {
        return LamiAnalysisStub.readLamiFile(this.fMetaDatafilename);
    }

    public boolean canExecute(ITmfTrace trace) {
        this.initialize();
        return true;
    }

    protected synchronized void initialize() {
        this.checkMetadata();
    }

    public LamiResultTable getResultTable(int index) {
        List<LamiResultTable> results = this.fResults;
        if (results == null) {
            throw new NullPointerException("Results are null. The analysis hasn't been run yet?");
        }
        return results.get(index);
    }

    private static @NonNull String readLamiFile(String filename) {
        String fileContent = "";
        try {
            Activator plugin = Activator.instance();
            if (plugin == null) {
                throw new IllegalStateException();
            }
            URL url = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path("testfiles/" + filename), null);
            if (url == null) {
                throw new IllegalArgumentException("lami file " + filename + " cannot be found");
            }
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream inputStream = url.openConnection().getInputStream();){
                BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
                fileContent = in.lines().collect(Collectors.joining());
                if (fileContent == null) {
                    fileContent = "";
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        return fileContent;
    }

    public @NonNull List<@NonNull LamiResultTable> execute(@NonNull ITmfTrace trace, @Nullable TmfTimeRange timeRange, @NonNull String extraParamsString, @NonNull IProgressMonitor monitor) throws CoreException {
        List results;
        this.fResults = results = super.execute(trace, timeRange, extraParamsString, monitor);
        return results;
    }
}

