/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers;

import java.util.regex.Pattern;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputStateProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SysExitHandler
extends KernelEventHandler {
    private static final String SYSCALL_READ_PATTERN = "[p]?read.*";
    private static final String SYSCALL_WRITE_PATTERN = "[p]?write.*";
    private final Pattern fSyscallReadPattern;
    private final Pattern fSyscallWritePattern;

    public SysExitHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
        this.fSyscallReadPattern = (Pattern)NonNullUtils.checkNotNull((Object)Pattern.compile("(" + layout.eventSyscallEntryPrefix() + "|" + layout.eventCompatSyscallEntryPrefix() + ")[p]?read.*"));
        this.fSyscallWritePattern = (Pattern)NonNullUtils.checkNotNull((Object)Pattern.compile("(" + layout.eventSyscallEntryPrefix() + "|" + layout.eventCompatSyscallEntryPrefix() + ")[p]?write.*"));
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        int ret;
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().getValue();
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return;
        }
        int syscallQuark = ss.optQuarkRelative(InputOutputStateProvider.getNodeSyscalls(ss), new String[]{String.valueOf(tid)});
        if (syscallQuark == -2) {
            return;
        }
        String syscallValue = ss.queryOngoingState(syscallQuark).unboxStr();
        Long retValue = (Long)content.getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
        if (retValue != null && (ret = retValue.intValue()) >= 0) {
            if (this.fSyscallReadPattern.matcher(syscallValue).matches()) {
                int currentProcessNode = ss.getQuarkRelativeAndAdd(InputOutputStateProvider.getNodeThreads(ss), new String[]{String.valueOf(tid)});
                int readQuark = ss.getQuarkRelativeAndAdd(currentProcessNode, new String[]{"bytes_read"});
                ss.getQuarkRelativeAndAdd(currentProcessNode, new String[]{"bytes_written"});
                StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)ts, (int)readQuark, (int)ret);
            } else if (this.fSyscallWritePattern.matcher(syscallValue).matches()) {
                int currentProcessNode = ss.getQuarkRelativeAndAdd(InputOutputStateProvider.getNodeThreads(ss), new String[]{String.valueOf(tid)});
                ss.getQuarkRelativeAndAdd(currentProcessNode, new String[]{"bytes_read"});
                int writtenQuark = ss.getQuarkRelativeAndAdd(currentProcessNode, new String[]{"bytes_written"});
                StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)ts, (int)writtenQuark, (int)ret);
            }
        }
        ss.modifyAttribute(ts, null, syscallQuark);
    }
}

