/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;

public class ThreadEntryModel
extends TimeGraphEntryModel {
    private final int fThreadId;
    private final int fParentThreadId;
    private final @NonNull Multimap<@NonNull String, @NonNull Object> fAspects;
    private final int fProcessId;

    public ThreadEntryModel(long id, long parentId, @NonNull List<@NonNull String> labels, long start, long end, int tid, int ppid, int pid) {
        super(id, parentId, labels, start, end);
        this.fThreadId = tid;
        this.fParentThreadId = ppid;
        this.fAspects = HashMultimap.create();
        this.fAspects.put((Object)OsStrings.tid(), (Object)tid);
        this.fAspects.put((Object)OsStrings.ptid(), (Object)ppid);
        this.fProcessId = pid <= 0 ? tid : pid;
        this.fAspects.put((Object)OsStrings.pid(), (Object)this.fProcessId);
        if (!labels.isEmpty()) {
            this.fAspects.put((Object)OsStrings.execName(), (Object)String.valueOf(labels.get(0)));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull List<@NonNull ITableColumnDescriptor> getColumnDescriptors() {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ImmutableList.Builder headers = new ImmutableList.Builder();
        TableColumnDescriptor.Builder builder = new TableColumnDescriptor.Builder();
        builder.setText(OsStrings.execName());
        builder.setTooltip(OsStrings.execNameDesc());
        headers.add((Object)builder.build());
        builder = new TableColumnDescriptor.Builder();
        builder.setText(OsStrings.tid());
        builder.setTooltip(OsStrings.tidDesc());
        headers.add((Object)builder.build());
        builder = new TableColumnDescriptor.Builder();
        builder.setText(OsStrings.pid());
        builder.setTooltip(OsStrings.pidDesc());
        headers.add((Object)builder.build());
        builder = new TableColumnDescriptor.Builder();
        builder.setText(OsStrings.ptid());
        builder.setTooltip(OsStrings.ptidDesc());
        headers.add((Object)builder.build());
        return headers.build();
    }

    public int getThreadId() {
        return this.fThreadId;
    }

    public int getParentThreadId() {
        return this.fParentThreadId;
    }

    public int getProcessId() {
        return this.fProcessId;
    }

    public @NonNull String toString() {
        return "<name=" + String.valueOf(this.getLabels()) + " id=" + this.getId() + " parentId=" + this.getParentId() + " start=" + this.getStartTime() + " end=" + this.getEndTime() + " TID=" + this.fThreadId + " PTID=" + this.fParentThreadId + ">";
    }

    public Multimap<@NonNull String, @NonNull Object> getMetadata() {
        return this.fAspects;
    }

    public boolean hasRowModel() {
        return this.getParentId() != -1L;
    }

    public static final class Builder {
        private final long fId;
        private @NonNull String fExecName;
        private final long fStartTime;
        private long fEndTime;
        private final int fTid;
        private int fPpid;
        private int fPid;

        public Builder(long id, @NonNull String execName, long start, long end, int tid, int ppid, int pid) {
            this.fId = id;
            this.fExecName = execName;
            this.fStartTime = start;
            this.fEndTime = end;
            this.fTid = tid;
            this.fPpid = ppid;
            this.fPid = pid;
        }

        public long getId() {
            return this.fId;
        }

        public long getStartTime() {
            return this.fStartTime;
        }

        public long getEndTime() {
            return this.fEndTime;
        }

        public int getPpid() {
            return this.fPpid;
        }

        public void setName(@NonNull String name) {
            this.fExecName = name;
        }

        public void setEndTime(long endTime) {
            this.fEndTime = Long.max(this.fEndTime, endTime);
        }

        public void setPpid(int ppid) {
            this.fPpid = ppid;
        }

        public void setPid(int pid) {
            if (pid >= 0) {
                this.fPid = pid;
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public ThreadEntryModel build(long parentId) {
            @NonNull @NonNull ImmutableList labels = ImmutableList.of((Object)this.fExecName, (Object)String.valueOf(this.fTid), (Object)(this.fPid <= 0 ? String.valueOf(this.fTid) : String.valueOf(this.fPid)), (Object)(this.fPpid > 0 ? String.valueOf(this.fPpid) : ""));
            return new ThreadEntryModel(this.fId, parentId, (List<String>)labels, this.fStartTime, this.fEndTime, this.fTid, this.fPpid, this.fPid);
        }
    }
}

