/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.CallStackTestData;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.CallStackAnalysisStub;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class CallStackTestBase {
    private final CallStackTestData fTraceData;
    private CallStackAnalysisStub fModule;

    public CallStackTestBase(CallStackTestData data) {
        this.fTraceData = data;
    }

    @Before
    public void setUp() {
        ITmfTrace trace = this.fTraceData.getTrace();
        CallStackAnalysisStub module = (CallStackAnalysisStub)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, CallStackAnalysisStub.class, (String)"org.eclipse.tracecompass.profiling.callstack.test");
        Assert.assertNotNull((Object)((Object)module));
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        this.fModule = module;
    }

    @After
    public void tearDown() {
        CallStackAnalysisStub module;
        CallStackTestData traceData = this.fTraceData;
        if (traceData != null) {
            traceData.dispose();
        }
        if ((module = this.fModule) != null) {
            module.dispose();
        }
    }

    public CallStackAnalysisStub getModule() {
        return this.fModule;
    }

    public @NonNull CallStackTestData getTraceData() {
        CallStackTestData traceData = this.fTraceData;
        if (traceData == null) {
            throw new NullPointerException();
        }
        return traceData;
    }
}

