/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FlameChartEntryModel;

public class FlameDataProviderTestUtils {
    public static @Nullable FlameChartEntryModel findEntryById(Collection<FlameChartEntryModel> list, long id) {
        return list.stream().filter(entry -> entry.getId() == id).findFirst().orElse(null);
    }

    public static @Nullable FlameChartEntryModel findEntryByNameAndType(Collection<FlameChartEntryModel> list, String name, FlameChartEntryModel.EntryType type) {
        return list.stream().filter(entry -> entry.getEntryType() == type && entry.getName().equals(name)).findFirst().orElse(null);
    }

    public static @Nullable FlameChartEntryModel findEntryByDepthAndType(Collection<FlameChartEntryModel> list, int depth, FlameChartEntryModel.EntryType type) {
        return list.stream().filter(entry -> entry.getEntryType() == type && entry.getDepth() == depth).findFirst().orElse(null);
    }

    public static List<FlameChartEntryModel> findEntriesByParent(Collection<FlameChartEntryModel> list, long parentId) {
        return list.stream().filter(entry -> entry.getParentId() == parentId).collect(Collectors.toList());
    }
}

